<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Waf\V20180125\Models;
use TencentCloud\Common\AbstractModel;

/**
 * SwitchDomainRules请求参数结构体
 *
 * @method string getDomain() 获取域名
 * @method void setDomain(string $Domain) 设置域名
 * @method array getIds() 获取规则列表
 * @method void setIds(array $Ids) 设置规则列表
 * @method integer getStatus() 获取开关状态，0表示关闭，1表示开启，2表示只观察
 * @method void setStatus(integer $Status) 设置开关状态，0表示关闭，1表示开启，2表示只观察
 * @method integer getReason() 获取设置为观察模式原因，
1表示业务自身原因观察，2表示系统规则误报上报，3表示核心业务灰度观察，4表示其他
 * @method void setReason(integer $Reason) 设置设置为观察模式原因，
1表示业务自身原因观察，2表示系统规则误报上报，3表示核心业务灰度观察，4表示其他
 */
class SwitchDomainRulesRequest extends AbstractModel
{
    /**
     * @var string 域名
     */
    public $Domain;

    /**
     * @var array 规则列表
     */
    public $Ids;

    /**
     * @var integer 开关状态，0表示关闭，1表示开启，2表示只观察
     */
    public $Status;

    /**
     * @var integer 设置为观察模式原因，
1表示业务自身原因观察，2表示系统规则误报上报，3表示核心业务灰度观察，4表示其他
     */
    public $Reason;

    /**
     * @param string $Domain 域名
     * @param array $Ids 规则列表
     * @param integer $Status 开关状态，0表示关闭，1表示开启，2表示只观察
     * @param integer $Reason 设置为观察模式原因，
1表示业务自身原因观察，2表示系统规则误报上报，3表示核心业务灰度观察，4表示其他
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Domain",$param) and $param["Domain"] !== null) {
            $this->Domain = $param["Domain"];
        }

        if (array_key_exists("Ids",$param) and $param["Ids"] !== null) {
            $this->Ids = $param["Ids"];
        }

        if (array_key_exists("Status",$param) and $param["Status"] !== null) {
            $this->Status = $param["Status"];
        }

        if (array_key_exists("Reason",$param) and $param["Reason"] !== null) {
            $this->Reason = $param["Reason"];
        }
    }
}
