<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Waf\V20180125\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeAccessIndex接口的出参数
 *
 * @method AccessFullTextInfo getFullText() 获取全文索引配置
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setFullText(AccessFullTextInfo $FullText) 设置全文索引配置
注意：此字段可能返回 null，表示取不到有效值。
 * @method AccessRuleKeyValueInfo getKeyValue() 获取键值索引配置
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setKeyValue(AccessRuleKeyValueInfo $KeyValue) 设置键值索引配置
注意：此字段可能返回 null，表示取不到有效值。
 * @method AccessRuleTagInfo getTag() 获取元字段索引配置
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTag(AccessRuleTagInfo $Tag) 设置元字段索引配置
注意：此字段可能返回 null，表示取不到有效值。
 */
class AccessRuleInfo extends AbstractModel
{
    /**
     * @var AccessFullTextInfo 全文索引配置
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $FullText;

    /**
     * @var AccessRuleKeyValueInfo 键值索引配置
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $KeyValue;

    /**
     * @var AccessRuleTagInfo 元字段索引配置
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Tag;

    /**
     * @param AccessFullTextInfo $FullText 全文索引配置
注意：此字段可能返回 null，表示取不到有效值。
     * @param AccessRuleKeyValueInfo $KeyValue 键值索引配置
注意：此字段可能返回 null，表示取不到有效值。
     * @param AccessRuleTagInfo $Tag 元字段索引配置
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("FullText",$param) and $param["FullText"] !== null) {
            $this->FullText = new AccessFullTextInfo();
            $this->FullText->deserialize($param["FullText"]);
        }

        if (array_key_exists("KeyValue",$param) and $param["KeyValue"] !== null) {
            $this->KeyValue = new AccessRuleKeyValueInfo();
            $this->KeyValue->deserialize($param["KeyValue"]);
        }

        if (array_key_exists("Tag",$param) and $param["Tag"] !== null) {
            $this->Tag = new AccessRuleTagInfo();
            $this->Tag->deserialize($param["Tag"]);
        }
    }
}
