<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Vpc\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeFlowLogs请求参数结构体
 *
 * @method string getVpcId() 获取私用网络唯一ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口获取。
 * @method void setVpcId(string $VpcId) 设置私用网络唯一ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口获取。
 * @method string getFlowLogId() 获取流日志唯一ID。可通过[CreateFlowLog](https://cloud.tencent.com/document/product/215/35015)接口创建。
 * @method void setFlowLogId(string $FlowLogId) 设置流日志唯一ID。可通过[CreateFlowLog](https://cloud.tencent.com/document/product/215/35015)接口创建。
 * @method string getFlowLogName() 获取流日志实例名称。长度不超过60个字符。
 * @method void setFlowLogName(string $FlowLogName) 设置流日志实例名称。长度不超过60个字符。
 * @method string getResourceType() 获取流日志所属资源类型，VPC（私有网络），SUBNET（子网），NETWORKINTERFACE（网卡），CCN（云联网），NAT（网络地址转化），DCG（专线网关）。

 * @method void setResourceType(string $ResourceType) 设置流日志所属资源类型，VPC（私有网络），SUBNET（子网），NETWORKINTERFACE（网卡），CCN（云联网），NAT（网络地址转化），DCG（专线网关）。

 * @method string getResourceId() 获取资源唯一ID。
 * @method void setResourceId(string $ResourceId) 设置资源唯一ID。
 * @method string getTrafficType() 获取流日志采集类型，ACCEPT（允许），REJECT（拒绝），ALL（全部）。
 * @method void setTrafficType(string $TrafficType) 设置流日志采集类型，ACCEPT（允许），REJECT（拒绝），ALL（全部）。
 * @method string getCloudLogId() 获取流日志存储ID。
 * @method void setCloudLogId(string $CloudLogId) 设置流日志存储ID。
 * @method string getCloudLogState() 获取流日志存储ID状态。SUCCESS（成功），DELETED（删除）
 * @method void setCloudLogState(string $CloudLogState) 设置流日志存储ID状态。SUCCESS（成功），DELETED（删除）
 * @method string getOrderField() 获取按某个字段排序,支持字段：flowLogName,createTime，默认按createTime。
 * @method void setOrderField(string $OrderField) 设置按某个字段排序,支持字段：flowLogName,createTime，默认按createTime。
 * @method string getOrderDirection() 获取升序（ASC）还是降序（DESC）,默认：DESC。
 * @method void setOrderDirection(string $OrderDirection) 设置升序（ASC）还是降序（DESC）,默认：DESC。
 * @method integer getOffset() 获取偏移量，默认为0。
 * @method void setOffset(integer $Offset) 设置偏移量，默认为0。
 * @method integer getLimit() 获取每页行数，默认为10。范围1-100。
 * @method void setLimit(integer $Limit) 设置每页行数，默认为10。范围1-100。
 * @method Filter getFilters() 获取过滤条件，参数不支持同时指定FlowLogId和Filters。
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。</li>
 * @method void setFilters(Filter $Filters) 设置过滤条件，参数不支持同时指定FlowLogId和Filters。
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。</li>
 * @method string getCloudLogRegion() 获取流日志存储ID对应的地域信息。
 * @method void setCloudLogRegion(string $CloudLogRegion) 设置流日志存储ID对应的地域信息。
 */
class DescribeFlowLogsRequest extends AbstractModel
{
    /**
     * @var string 私用网络唯一ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口获取。
     */
    public $VpcId;

    /**
     * @var string 流日志唯一ID。可通过[CreateFlowLog](https://cloud.tencent.com/document/product/215/35015)接口创建。
     */
    public $FlowLogId;

    /**
     * @var string 流日志实例名称。长度不超过60个字符。
     */
    public $FlowLogName;

    /**
     * @var string 流日志所属资源类型，VPC（私有网络），SUBNET（子网），NETWORKINTERFACE（网卡），CCN（云联网），NAT（网络地址转化），DCG（专线网关）。

     */
    public $ResourceType;

    /**
     * @var string 资源唯一ID。
     */
    public $ResourceId;

    /**
     * @var string 流日志采集类型，ACCEPT（允许），REJECT（拒绝），ALL（全部）。
     */
    public $TrafficType;

    /**
     * @var string 流日志存储ID。
     */
    public $CloudLogId;

    /**
     * @var string 流日志存储ID状态。SUCCESS（成功），DELETED（删除）
     */
    public $CloudLogState;

    /**
     * @var string 按某个字段排序,支持字段：flowLogName,createTime，默认按createTime。
     */
    public $OrderField;

    /**
     * @var string 升序（ASC）还是降序（DESC）,默认：DESC。
     */
    public $OrderDirection;

    /**
     * @var integer 偏移量，默认为0。
     */
    public $Offset;

    /**
     * @var integer 每页行数，默认为10。范围1-100。
     */
    public $Limit;

    /**
     * @var Filter 过滤条件，参数不支持同时指定FlowLogId和Filters。
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。</li>
     */
    public $Filters;

    /**
     * @var string 流日志存储ID对应的地域信息。
     */
    public $CloudLogRegion;

    /**
     * @param string $VpcId 私用网络唯一ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口获取。
     * @param string $FlowLogId 流日志唯一ID。可通过[CreateFlowLog](https://cloud.tencent.com/document/product/215/35015)接口创建。
     * @param string $FlowLogName 流日志实例名称。长度不超过60个字符。
     * @param string $ResourceType 流日志所属资源类型，VPC（私有网络），SUBNET（子网），NETWORKINTERFACE（网卡），CCN（云联网），NAT（网络地址转化），DCG（专线网关）。

     * @param string $ResourceId 资源唯一ID。
     * @param string $TrafficType 流日志采集类型，ACCEPT（允许），REJECT（拒绝），ALL（全部）。
     * @param string $CloudLogId 流日志存储ID。
     * @param string $CloudLogState 流日志存储ID状态。SUCCESS（成功），DELETED（删除）
     * @param string $OrderField 按某个字段排序,支持字段：flowLogName,createTime，默认按createTime。
     * @param string $OrderDirection 升序（ASC）还是降序（DESC）,默认：DESC。
     * @param integer $Offset 偏移量，默认为0。
     * @param integer $Limit 每页行数，默认为10。范围1-100。
     * @param Filter $Filters 过滤条件，参数不支持同时指定FlowLogId和Filters。
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。</li>
     * @param string $CloudLogRegion 流日志存储ID对应的地域信息。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("VpcId",$param) and $param["VpcId"] !== null) {
            $this->VpcId = $param["VpcId"];
        }

        if (array_key_exists("FlowLogId",$param) and $param["FlowLogId"] !== null) {
            $this->FlowLogId = $param["FlowLogId"];
        }

        if (array_key_exists("FlowLogName",$param) and $param["FlowLogName"] !== null) {
            $this->FlowLogName = $param["FlowLogName"];
        }

        if (array_key_exists("ResourceType",$param) and $param["ResourceType"] !== null) {
            $this->ResourceType = $param["ResourceType"];
        }

        if (array_key_exists("ResourceId",$param) and $param["ResourceId"] !== null) {
            $this->ResourceId = $param["ResourceId"];
        }

        if (array_key_exists("TrafficType",$param) and $param["TrafficType"] !== null) {
            $this->TrafficType = $param["TrafficType"];
        }

        if (array_key_exists("CloudLogId",$param) and $param["CloudLogId"] !== null) {
            $this->CloudLogId = $param["CloudLogId"];
        }

        if (array_key_exists("CloudLogState",$param) and $param["CloudLogState"] !== null) {
            $this->CloudLogState = $param["CloudLogState"];
        }

        if (array_key_exists("OrderField",$param) and $param["OrderField"] !== null) {
            $this->OrderField = $param["OrderField"];
        }

        if (array_key_exists("OrderDirection",$param) and $param["OrderDirection"] !== null) {
            $this->OrderDirection = $param["OrderDirection"];
        }

        if (array_key_exists("Offset",$param) and $param["Offset"] !== null) {
            $this->Offset = $param["Offset"];
        }

        if (array_key_exists("Limit",$param) and $param["Limit"] !== null) {
            $this->Limit = $param["Limit"];
        }

        if (array_key_exists("Filters",$param) and $param["Filters"] !== null) {
            $this->Filters = new Filter();
            $this->Filters->deserialize($param["Filters"]);
        }

        if (array_key_exists("CloudLogRegion",$param) and $param["CloudLogRegion"] !== null) {
            $this->CloudLogRegion = $param["CloudLogRegion"];
        }
    }
}
