<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Vod\V20180717\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 即时转码水印模板配置。
 *
 * @method string getSwitch() 获取是否启用水印。可取值：
<li>ON：表示启用水印；</li>
<li>OFF：表示关闭水印。</li>
 * @method void setSwitch(string $Switch) 设置是否启用水印。可取值：
<li>ON：表示启用水印；</li>
<li>OFF：表示关闭水印。</li>
 * @method string getImageContent() 获取水印图片 Base64 编码后的字符串。支持 jpeg、png 图片格式。
 * @method void setImageContent(string $ImageContent) 设置水印图片 Base64 编码后的字符串。支持 jpeg、png 图片格式。
 * @method string getWidth() 获取水印的宽度。
<li>字符串以 % 结尾，表示水印 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
 * @method void setWidth(string $Width) 设置水印的宽度。
<li>字符串以 % 结尾，表示水印 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
 * @method string getHeight() 获取水印的高度。
<li>字符串以 % 结尾，表示水印 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
 * @method void setHeight(string $Height) 设置水印的高度。
<li>字符串以 % 结尾，表示水印 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
 * @method string getXPos() 获取水印原点距离视频图像坐标原点的水平位置。字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；
 * @method void setXPos(string $XPos) 设置水印原点距离视频图像坐标原点的水平位置。字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；
 * @method string getYPos() 获取水印原点距离视频图像坐标原点的垂直位置。当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%。
 * @method void setYPos(string $YPos) 设置水印原点距离视频图像坐标原点的垂直位置。当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%。
 */
class WatermarkConfigureInfo extends AbstractModel
{
    /**
     * @var string 是否启用水印。可取值：
<li>ON：表示启用水印；</li>
<li>OFF：表示关闭水印。</li>
     */
    public $Switch;

    /**
     * @var string 水印图片 Base64 编码后的字符串。支持 jpeg、png 图片格式。
     */
    public $ImageContent;

    /**
     * @var string 水印的宽度。
<li>字符串以 % 结尾，表示水印 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
     */
    public $Width;

    /**
     * @var string 水印的高度。
<li>字符串以 % 结尾，表示水印 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
     */
    public $Height;

    /**
     * @var string 水印原点距离视频图像坐标原点的水平位置。字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；
     */
    public $XPos;

    /**
     * @var string 水印原点距离视频图像坐标原点的垂直位置。当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%。
     */
    public $YPos;

    /**
     * @param string $Switch 是否启用水印。可取值：
<li>ON：表示启用水印；</li>
<li>OFF：表示关闭水印。</li>
     * @param string $ImageContent 水印图片 Base64 编码后的字符串。支持 jpeg、png 图片格式。
     * @param string $Width 水印的宽度。
<li>字符串以 % 结尾，表示水印 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
     * @param string $Height 水印的高度。
<li>字符串以 % 结尾，表示水印 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
     * @param string $XPos 水印原点距离视频图像坐标原点的水平位置。字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；
     * @param string $YPos 水印原点距离视频图像坐标原点的垂直位置。当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Switch",$param) and $param["Switch"] !== null) {
            $this->Switch = $param["Switch"];
        }

        if (array_key_exists("ImageContent",$param) and $param["ImageContent"] !== null) {
            $this->ImageContent = $param["ImageContent"];
        }

        if (array_key_exists("Width",$param) and $param["Width"] !== null) {
            $this->Width = $param["Width"];
        }

        if (array_key_exists("Height",$param) and $param["Height"] !== null) {
            $this->Height = $param["Height"];
        }

        if (array_key_exists("XPos",$param) and $param["XPos"] !== null) {
            $this->XPos = $param["XPos"];
        }

        if (array_key_exists("YPos",$param) and $param["YPos"] !== null) {
            $this->YPos = $param["YPos"];
        }
    }
}
