<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Trtc\V20190722\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 转推参数。
 *
 * @method string getPublishCdnUrl() 获取CDN转推URL，只支持rtmp链接。
注：若更新转推时，URL有任何变化，都会断流重推。
 * @method void setPublishCdnUrl(string $PublishCdnUrl) 设置CDN转推URL，只支持rtmp链接。
注：若更新转推时，URL有任何变化，都会断流重推。
 * @method integer getIsTencentCdn() 获取是否是腾讯云CDN，0为转推非腾讯云CDN，1为转推腾讯CDN，不携带该参数默认为1。注意：1，为避免误产生转推费用，该参数建议明确填写，转推非腾讯云CDN时会产生转推费用，详情参见接口文档说明；2，国内站默认只支持转推腾讯云CDN，如您有转推第三方CDN需求，请联系腾讯云技术支持。
 * @method void setIsTencentCdn(integer $IsTencentCdn) 设置是否是腾讯云CDN，0为转推非腾讯云CDN，1为转推腾讯CDN，不携带该参数默认为1。注意：1，为避免误产生转推费用，该参数建议明确填写，转推非腾讯云CDN时会产生转推费用，详情参见接口文档说明；2，国内站默认只支持转推腾讯云CDN，如您有转推第三方CDN需求，请联系腾讯云技术支持。
 */
class McuPublishCdnParam extends AbstractModel
{
    /**
     * @var string CDN转推URL，只支持rtmp链接。
注：若更新转推时，URL有任何变化，都会断流重推。
     */
    public $PublishCdnUrl;

    /**
     * @var integer 是否是腾讯云CDN，0为转推非腾讯云CDN，1为转推腾讯CDN，不携带该参数默认为1。注意：1，为避免误产生转推费用，该参数建议明确填写，转推非腾讯云CDN时会产生转推费用，详情参见接口文档说明；2，国内站默认只支持转推腾讯云CDN，如您有转推第三方CDN需求，请联系腾讯云技术支持。
     */
    public $IsTencentCdn;

    /**
     * @param string $PublishCdnUrl CDN转推URL，只支持rtmp链接。
注：若更新转推时，URL有任何变化，都会断流重推。
     * @param integer $IsTencentCdn 是否是腾讯云CDN，0为转推非腾讯云CDN，1为转推腾讯CDN，不携带该参数默认为1。注意：1，为避免误产生转推费用，该参数建议明确填写，转推非腾讯云CDN时会产生转推费用，详情参见接口文档说明；2，国内站默认只支持转推腾讯云CDN，如您有转推第三方CDN需求，请联系腾讯云技术支持。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("PublishCdnUrl",$param) and $param["PublishCdnUrl"] !== null) {
            $this->PublishCdnUrl = $param["PublishCdnUrl"];
        }

        if (array_key_exists("IsTencentCdn",$param) and $param["IsTencentCdn"] !== null) {
            $this->IsTencentCdn = $param["IsTencentCdn"];
        }
    }
}
