<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tdmq\V20200217\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 角色实例
 *
 * @method string getRoleName() 获取角色名称。
 * @method void setRoleName(string $RoleName) 设置角色名称。
 * @method string getToken() 获取角色token值。
 * @method void setToken(string $Token) 设置角色token值。
 * @method string getRemark() 获取备注说明。
 * @method void setRemark(string $Remark) 设置备注说明。
 * @method string getCreateTime() 获取创建时间。
 * @method void setCreateTime(string $CreateTime) 设置创建时间。
 * @method string getUpdateTime() 获取更新时间。
 * @method void setUpdateTime(string $UpdateTime) 设置更新时间。
 * @method string getPermType() 获取授权类型（Cluster：集群；TopicAndGroup：主题或消费组）
 * @method void setPermType(string $PermType) 设置授权类型（Cluster：集群；TopicAndGroup：主题或消费组）
 */
class Role extends AbstractModel
{
    /**
     * @var string 角色名称。
     */
    public $RoleName;

    /**
     * @var string 角色token值。
     */
    public $Token;

    /**
     * @var string 备注说明。
     */
    public $Remark;

    /**
     * @var string 创建时间。
     */
    public $CreateTime;

    /**
     * @var string 更新时间。
     */
    public $UpdateTime;

    /**
     * @var string 授权类型（Cluster：集群；TopicAndGroup：主题或消费组）
     */
    public $PermType;

    /**
     * @param string $RoleName 角色名称。
     * @param string $Token 角色token值。
     * @param string $Remark 备注说明。
     * @param string $CreateTime 创建时间。
     * @param string $UpdateTime 更新时间。
     * @param string $PermType 授权类型（Cluster：集群；TopicAndGroup：主题或消费组）
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("RoleName",$param) and $param["RoleName"] !== null) {
            $this->RoleName = $param["RoleName"];
        }

        if (array_key_exists("Token",$param) and $param["Token"] !== null) {
            $this->Token = $param["Token"];
        }

        if (array_key_exists("Remark",$param) and $param["Remark"] !== null) {
            $this->Remark = $param["Remark"];
        }

        if (array_key_exists("CreateTime",$param) and $param["CreateTime"] !== null) {
            $this->CreateTime = $param["CreateTime"];
        }

        if (array_key_exists("UpdateTime",$param) and $param["UpdateTime"] !== null) {
            $this->UpdateTime = $param["UpdateTime"];
        }

        if (array_key_exists("PermType",$param) and $param["PermType"] !== null) {
            $this->PermType = $param["PermType"];
        }
    }
}
