<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tdid\V20210519\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 可验证凭证证明信息
 *
 * @method string getCredential() 获取可验证凭证内容
 * @method void setCredential(string $Credential) 设置可验证凭证内容
 */
class CredentialProof extends AbstractModel
{
    /**
     * @var string 可验证凭证内容
     */
    public $Credential;

    /**
     * @param string $Credential 可验证凭证内容
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Credential",$param) and $param["Credential"] !== null) {
            $this->Credential = $param["Credential"];
        }
    }
}
