<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ssl\V20191205\Models;
use TencentCloud\Common\AbstractModel;

/**
 * teo实例详情
 *
 * @method string getHost() 获取域名
 * @method void setHost(string $Host) 设置域名
 * @method string getCertId() 获取证书ID
 * @method void setCertId(string $CertId) 设置证书ID
 * @method string getZoneId() 获取区域ID
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setZoneId(string $ZoneId) 设置区域ID
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getStatus() 获取域名状态
deployed：已部署；
processing：部署中；
applying：申请中；
failed：申请失败；
issued：绑定失败。
 * @method void setStatus(string $Status) 设置域名状态
deployed：已部署；
processing：部署中；
applying：申请中；
failed：申请失败；
issued：绑定失败。
 */
class TeoInstanceDetail extends AbstractModel
{
    /**
     * @var string 域名
     */
    public $Host;

    /**
     * @var string 证书ID
     */
    public $CertId;

    /**
     * @var string 区域ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $ZoneId;

    /**
     * @var string 域名状态
deployed：已部署；
processing：部署中；
applying：申请中；
failed：申请失败；
issued：绑定失败。
     */
    public $Status;

    /**
     * @param string $Host 域名
     * @param string $CertId 证书ID
     * @param string $ZoneId 区域ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Status 域名状态
deployed：已部署；
processing：部署中；
applying：申请中；
failed：申请失败；
issued：绑定失败。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Host",$param) and $param["Host"] !== null) {
            $this->Host = $param["Host"];
        }

        if (array_key_exists("CertId",$param) and $param["CertId"] !== null) {
            $this->CertId = $param["CertId"];
        }

        if (array_key_exists("ZoneId",$param) and $param["ZoneId"] !== null) {
            $this->ZoneId = $param["ZoneId"];
        }

        if (array_key_exists("Status",$param) and $param["Status"] !== null) {
            $this->Status = $param["Status"];
        }
    }
}
