<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Sqlserver\V20180328\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 实例详细信息
 *
 * @method string getInstanceId() 获取实例ID
 * @method void setInstanceId(string $InstanceId) 设置实例ID
 * @method string getName() 获取实例名称
 * @method void setName(string $Name) 设置实例名称
 * @method integer getProjectId() 获取实例所在项目ID
 * @method void setProjectId(integer $ProjectId) 设置实例所在项目ID
 * @method integer getRegionId() 获取实例所在地域ID
 * @method void setRegionId(integer $RegionId) 设置实例所在地域ID
 * @method integer getZoneId() 获取实例所在可用区ID
 * @method void setZoneId(integer $ZoneId) 设置实例所在可用区ID
 * @method integer getVpcId() 获取实例所在私有网络ID，基础网络时为 0
 * @method void setVpcId(integer $VpcId) 设置实例所在私有网络ID，基础网络时为 0
 * @method integer getSubnetId() 获取实例所在私有网络子网ID，基础网络时为 0
 * @method void setSubnetId(integer $SubnetId) 设置实例所在私有网络子网ID，基础网络时为 0
 * @method integer getStatus() 获取实例状态。取值范围： <li>1：申请中</li> <li>2：运行中</li> <li>3：受限运行中 (主备切换中)</li> <li>4：已隔离</li> <li>5：回收中</li> <li>6：已回收</li> <li>7：任务执行中 (实例做备份、回档等操作)</li> <li>8：已下线</li> <li>9：实例扩容中</li> <li>10：实例迁移中</li> <li>11：只读</li> <li>12：重启中</li>  <li>13：实例修改中且待切换</li> <li>14：订阅发布创建中</li> <li>15：订阅发布修改中</li> <li>16：实例修改中且切换中</li> <li>17：创建RO副本中</li>
 * @method void setStatus(integer $Status) 设置实例状态。取值范围： <li>1：申请中</li> <li>2：运行中</li> <li>3：受限运行中 (主备切换中)</li> <li>4：已隔离</li> <li>5：回收中</li> <li>6：已回收</li> <li>7：任务执行中 (实例做备份、回档等操作)</li> <li>8：已下线</li> <li>9：实例扩容中</li> <li>10：实例迁移中</li> <li>11：只读</li> <li>12：重启中</li>  <li>13：实例修改中且待切换</li> <li>14：订阅发布创建中</li> <li>15：订阅发布修改中</li> <li>16：实例修改中且切换中</li> <li>17：创建RO副本中</li>
 * @method string getVip() 获取实例访问IP
 * @method void setVip(string $Vip) 设置实例访问IP
 * @method integer getVport() 获取实例访问端口
 * @method void setVport(integer $Vport) 设置实例访问端口
 * @method string getCreateTime() 获取实例创建时间
 * @method void setCreateTime(string $CreateTime) 设置实例创建时间
 * @method string getUpdateTime() 获取实例更新时间
 * @method void setUpdateTime(string $UpdateTime) 设置实例更新时间
 * @method string getStartTime() 获取实例计费开始时间
 * @method void setStartTime(string $StartTime) 设置实例计费开始时间
 * @method string getEndTime() 获取实例计费结束时间
 * @method void setEndTime(string $EndTime) 设置实例计费结束时间
 * @method string getIsolateTime() 获取实例隔离时间
 * @method void setIsolateTime(string $IsolateTime) 设置实例隔离时间
 * @method integer getMemory() 获取实例内存大小，单位G
 * @method void setMemory(integer $Memory) 设置实例内存大小，单位G
 * @method integer getUsedStorage() 获取实例已经使用存储空间大小，单位G
 * @method void setUsedStorage(integer $UsedStorage) 设置实例已经使用存储空间大小，单位G
 * @method integer getStorage() 获取实例存储空间大小，单位G
 * @method void setStorage(integer $Storage) 设置实例存储空间大小，单位G
 * @method string getVersionName() 获取实例版本
 * @method void setVersionName(string $VersionName) 设置实例版本
 * @method integer getRenewFlag() 获取实例续费标记，0-正常续费，1-自动续费，2-到期不续费
 * @method void setRenewFlag(integer $RenewFlag) 设置实例续费标记，0-正常续费，1-自动续费，2-到期不续费
 * @method integer getModel() 获取实例高可用， 1-双机高可用，2-单机，3-跨可用区，4-集群跨可用区，5-集群，6-多节点集群，7-多节点集群跨可用区，9-自研机房
 * @method void setModel(integer $Model) 设置实例高可用， 1-双机高可用，2-单机，3-跨可用区，4-集群跨可用区，5-集群，6-多节点集群，7-多节点集群跨可用区，9-自研机房
 * @method string getRegion() 获取实例所在地域名称，如 ap-guangzhou
 * @method void setRegion(string $Region) 设置实例所在地域名称，如 ap-guangzhou
 * @method string getZone() 获取实例所在可用区名称，如 ap-guangzhou-1
 * @method void setZone(string $Zone) 设置实例所在可用区名称，如 ap-guangzhou-1
 * @method string getBackupTime() 获取备份时间点
 * @method void setBackupTime(string $BackupTime) 设置备份时间点
 * @method integer getPayMode() 获取实例付费模式， 0-按量计费，1-包年包月
 * @method void setPayMode(integer $PayMode) 设置实例付费模式， 0-按量计费，1-包年包月
 * @method string getUid() 获取实例唯一UID
 * @method void setUid(string $Uid) 设置实例唯一UID
 * @method integer getCpu() 获取实例cpu核心数
 * @method void setCpu(integer $Cpu) 设置实例cpu核心数
 * @method string getVersion() 获取实例版本代号
 * @method void setVersion(string $Version) 设置实例版本代号
 * @method string getType() 获取实例类型代号："TS85"-物理机，本地SSD硬盘；"Z3"-物理机早期版本，本地SSD硬盘；"CLOUD_BASIC"-虚拟机，普通云硬盘；"CLOUD_PREMIUM"-虚拟机，高性能云硬盘；"CLOUD_SSD"-虚拟机，云SSD硬盘；"CLOUD_HSSD"-虚拟机，增强型SSD云硬盘；"CLOUD_TSSD"-虚拟机，极速型SSD云硬盘；"CLOUD_BSSD"-虚拟机，通用型SSD云硬盘
 * @method void setType(string $Type) 设置实例类型代号："TS85"-物理机，本地SSD硬盘；"Z3"-物理机早期版本，本地SSD硬盘；"CLOUD_BASIC"-虚拟机，普通云硬盘；"CLOUD_PREMIUM"-虚拟机，高性能云硬盘；"CLOUD_SSD"-虚拟机，云SSD硬盘；"CLOUD_HSSD"-虚拟机，增强型SSD云硬盘；"CLOUD_TSSD"-虚拟机，极速型SSD云硬盘；"CLOUD_BSSD"-虚拟机，通用型SSD云硬盘
 * @method integer getPid() 获取计费ID
 * @method void setPid(integer $Pid) 设置计费ID
 * @method string getUniqVpcId() 获取实例所属VPC的唯一字符串ID，格式如：vpc-xxx，基础网络时为空字符串
 * @method void setUniqVpcId(string $UniqVpcId) 设置实例所属VPC的唯一字符串ID，格式如：vpc-xxx，基础网络时为空字符串
 * @method string getUniqSubnetId() 获取实例所属子网的唯一字符串ID，格式如： subnet-xxx，基础网络时为空字符串
 * @method void setUniqSubnetId(string $UniqSubnetId) 设置实例所属子网的唯一字符串ID，格式如： subnet-xxx，基础网络时为空字符串
 * @method string getIsolateOperator() 获取实例隔离操作
 * @method void setIsolateOperator(string $IsolateOperator) 设置实例隔离操作
 * @method string getSubFlag() 获取发布订阅标识，SUB-订阅实例，PUB-发布实例，空值-没有发布订阅的普通实例
 * @method void setSubFlag(string $SubFlag) 设置发布订阅标识，SUB-订阅实例，PUB-发布实例，空值-没有发布订阅的普通实例
 * @method string getROFlag() 获取只读标识，RO-只读实例，MASTER-有RO实例的主实例，空值-没有只读组的非RO实例
 * @method void setROFlag(string $ROFlag) 设置只读标识，RO-只读实例，MASTER-有RO实例的主实例，空值-没有只读组的非RO实例
 * @method string getHAFlag() 获取容灾类型，MIRROR-镜像，ALWAYSON-AlwaysOn, SINGLE-单例
 * @method void setHAFlag(string $HAFlag) 设置容灾类型，MIRROR-镜像，ALWAYSON-AlwaysOn, SINGLE-单例
 * @method array getResourceTags() 获取实例绑定的标签列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setResourceTags(array $ResourceTags) 设置实例绑定的标签列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getBackupModel() 获取备份模式，master_pkg-主节点打包备份(默认) ；master_no_pkg-主节点不打包备份；slave_pkg-从节点打包备份(always on集群有效)；slave_no_pkg-从节点不打包备份(always on集群有效)；只读副本对该值无效。
 * @method void setBackupModel(string $BackupModel) 设置备份模式，master_pkg-主节点打包备份(默认) ；master_no_pkg-主节点不打包备份；slave_pkg-从节点打包备份(always on集群有效)；slave_no_pkg-从节点不打包备份(always on集群有效)；只读副本对该值无效。
 * @method string getInstanceNote() 获取实例备份信息
 * @method void setInstanceNote(string $InstanceNote) 设置实例备份信息
 * @method array getBackupCycle() 获取备份周期
 * @method void setBackupCycle(array $BackupCycle) 设置备份周期
 * @method string getBackupCycleType() 获取备份周期类型，[daily、weekly、monthly]
 * @method void setBackupCycleType(string $BackupCycleType) 设置备份周期类型，[daily、weekly、monthly]
 * @method integer getBackupSaveDays() 获取数据(日志)备份保留时间
 * @method void setBackupSaveDays(integer $BackupSaveDays) 设置数据(日志)备份保留时间
 * @method string getInstanceType() 获取实例类型 HA-高可用，RO-只读实例，SI-基础版，BI-商业智能服务，cvmHA-云盘高可用，cvmRO-云盘只读实例，MultiHA-多节点，cvmMultiHA-云盘多节点

 * @method void setInstanceType(string $InstanceType) 设置实例类型 HA-高可用，RO-只读实例，SI-基础版，BI-商业智能服务，cvmHA-云盘高可用，cvmRO-云盘只读实例，MultiHA-多节点，cvmMultiHA-云盘多节点

 * @method array getCrossRegions() 获取跨地域备份目的地域，如果为空，则表示未开启跨地域备份
 * @method void setCrossRegions(array $CrossRegions) 设置跨地域备份目的地域，如果为空，则表示未开启跨地域备份
 * @method string getCrossBackupEnabled() 获取跨地域备份状态 enable-开启，disable-关闭
 * @method void setCrossBackupEnabled(string $CrossBackupEnabled) 设置跨地域备份状态 enable-开启，disable-关闭
 * @method integer getCrossBackupSaveDays() 获取跨地域备份保留天数，则默认7天
 * @method void setCrossBackupSaveDays(integer $CrossBackupSaveDays) 设置跨地域备份保留天数，则默认7天
 * @method string getDnsPodDomain() 获取外网地址域名
 * @method void setDnsPodDomain(string $DnsPodDomain) 设置外网地址域名
 * @method integer getTgwWanVPort() 获取外网端口号
 * @method void setTgwWanVPort(integer $TgwWanVPort) 设置外网端口号
 * @method string getCollation() 获取系统字符集排序规则，默认：Chinese_PRC_CI_AS
 * @method void setCollation(string $Collation) 设置系统字符集排序规则，默认：Chinese_PRC_CI_AS
 * @method string getTimeZone() 获取系统时区，默认：China Standard Time
 * @method void setTimeZone(string $TimeZone) 设置系统时区，默认：China Standard Time
 * @method boolean getIsDrZone() 获取是否跨AZ
 * @method void setIsDrZone(boolean $IsDrZone) 设置是否跨AZ
 * @method SlaveZones getSlaveZones() 获取双节点实例备可用区信息
 * @method void setSlaveZones(SlaveZones $SlaveZones) 设置双节点实例备可用区信息
 * @method string getArchitecture() 获取架构标识，SINGLE-单节点 DOUBLE-双节点
 * @method void setArchitecture(string $Architecture) 设置架构标识，SINGLE-单节点 DOUBLE-双节点
 * @method string getStyle() 获取类型标识，EXCLUSIVE-独享型，SHARED-共享型
 * @method void setStyle(string $Style) 设置类型标识，EXCLUSIVE-独享型，SHARED-共享型
 * @method array getMultiSlaveZones() 获取多节点实例备可用区信息
 * @method void setMultiSlaveZones(array $MultiSlaveZones) 设置多节点实例备可用区信息
 */
class DBInstance extends AbstractModel
{
    /**
     * @var string 实例ID
     */
    public $InstanceId;

    /**
     * @var string 实例名称
     */
    public $Name;

    /**
     * @var integer 实例所在项目ID
     */
    public $ProjectId;

    /**
     * @var integer 实例所在地域ID
     */
    public $RegionId;

    /**
     * @var integer 实例所在可用区ID
     */
    public $ZoneId;

    /**
     * @var integer 实例所在私有网络ID，基础网络时为 0
     */
    public $VpcId;

    /**
     * @var integer 实例所在私有网络子网ID，基础网络时为 0
     */
    public $SubnetId;

    /**
     * @var integer 实例状态。取值范围： <li>1：申请中</li> <li>2：运行中</li> <li>3：受限运行中 (主备切换中)</li> <li>4：已隔离</li> <li>5：回收中</li> <li>6：已回收</li> <li>7：任务执行中 (实例做备份、回档等操作)</li> <li>8：已下线</li> <li>9：实例扩容中</li> <li>10：实例迁移中</li> <li>11：只读</li> <li>12：重启中</li>  <li>13：实例修改中且待切换</li> <li>14：订阅发布创建中</li> <li>15：订阅发布修改中</li> <li>16：实例修改中且切换中</li> <li>17：创建RO副本中</li>
     */
    public $Status;

    /**
     * @var string 实例访问IP
     */
    public $Vip;

    /**
     * @var integer 实例访问端口
     */
    public $Vport;

    /**
     * @var string 实例创建时间
     */
    public $CreateTime;

    /**
     * @var string 实例更新时间
     */
    public $UpdateTime;

    /**
     * @var string 实例计费开始时间
     */
    public $StartTime;

    /**
     * @var string 实例计费结束时间
     */
    public $EndTime;

    /**
     * @var string 实例隔离时间
     */
    public $IsolateTime;

    /**
     * @var integer 实例内存大小，单位G
     */
    public $Memory;

    /**
     * @var integer 实例已经使用存储空间大小，单位G
     */
    public $UsedStorage;

    /**
     * @var integer 实例存储空间大小，单位G
     */
    public $Storage;

    /**
     * @var string 实例版本
     */
    public $VersionName;

    /**
     * @var integer 实例续费标记，0-正常续费，1-自动续费，2-到期不续费
     */
    public $RenewFlag;

    /**
     * @var integer 实例高可用， 1-双机高可用，2-单机，3-跨可用区，4-集群跨可用区，5-集群，6-多节点集群，7-多节点集群跨可用区，9-自研机房
     */
    public $Model;

    /**
     * @var string 实例所在地域名称，如 ap-guangzhou
     */
    public $Region;

    /**
     * @var string 实例所在可用区名称，如 ap-guangzhou-1
     */
    public $Zone;

    /**
     * @var string 备份时间点
     */
    public $BackupTime;

    /**
     * @var integer 实例付费模式， 0-按量计费，1-包年包月
     */
    public $PayMode;

    /**
     * @var string 实例唯一UID
     */
    public $Uid;

    /**
     * @var integer 实例cpu核心数
     */
    public $Cpu;

    /**
     * @var string 实例版本代号
     */
    public $Version;

    /**
     * @var string 实例类型代号："TS85"-物理机，本地SSD硬盘；"Z3"-物理机早期版本，本地SSD硬盘；"CLOUD_BASIC"-虚拟机，普通云硬盘；"CLOUD_PREMIUM"-虚拟机，高性能云硬盘；"CLOUD_SSD"-虚拟机，云SSD硬盘；"CLOUD_HSSD"-虚拟机，增强型SSD云硬盘；"CLOUD_TSSD"-虚拟机，极速型SSD云硬盘；"CLOUD_BSSD"-虚拟机，通用型SSD云硬盘
     */
    public $Type;

    /**
     * @var integer 计费ID
     */
    public $Pid;

    /**
     * @var string 实例所属VPC的唯一字符串ID，格式如：vpc-xxx，基础网络时为空字符串
     */
    public $UniqVpcId;

    /**
     * @var string 实例所属子网的唯一字符串ID，格式如： subnet-xxx，基础网络时为空字符串
     */
    public $UniqSubnetId;

    /**
     * @var string 实例隔离操作
     */
    public $IsolateOperator;

    /**
     * @var string 发布订阅标识，SUB-订阅实例，PUB-发布实例，空值-没有发布订阅的普通实例
     */
    public $SubFlag;

    /**
     * @var string 只读标识，RO-只读实例，MASTER-有RO实例的主实例，空值-没有只读组的非RO实例
     */
    public $ROFlag;

    /**
     * @var string 容灾类型，MIRROR-镜像，ALWAYSON-AlwaysOn, SINGLE-单例
     */
    public $HAFlag;

    /**
     * @var array 实例绑定的标签列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $ResourceTags;

    /**
     * @var string 备份模式，master_pkg-主节点打包备份(默认) ；master_no_pkg-主节点不打包备份；slave_pkg-从节点打包备份(always on集群有效)；slave_no_pkg-从节点不打包备份(always on集群有效)；只读副本对该值无效。
     */
    public $BackupModel;

    /**
     * @var string 实例备份信息
     */
    public $InstanceNote;

    /**
     * @var array 备份周期
     */
    public $BackupCycle;

    /**
     * @var string 备份周期类型，[daily、weekly、monthly]
     */
    public $BackupCycleType;

    /**
     * @var integer 数据(日志)备份保留时间
     */
    public $BackupSaveDays;

    /**
     * @var string 实例类型 HA-高可用，RO-只读实例，SI-基础版，BI-商业智能服务，cvmHA-云盘高可用，cvmRO-云盘只读实例，MultiHA-多节点，cvmMultiHA-云盘多节点

     */
    public $InstanceType;

    /**
     * @var array 跨地域备份目的地域，如果为空，则表示未开启跨地域备份
     */
    public $CrossRegions;

    /**
     * @var string 跨地域备份状态 enable-开启，disable-关闭
     */
    public $CrossBackupEnabled;

    /**
     * @var integer 跨地域备份保留天数，则默认7天
     */
    public $CrossBackupSaveDays;

    /**
     * @var string 外网地址域名
     */
    public $DnsPodDomain;

    /**
     * @var integer 外网端口号
     */
    public $TgwWanVPort;

    /**
     * @var string 系统字符集排序规则，默认：Chinese_PRC_CI_AS
     */
    public $Collation;

    /**
     * @var string 系统时区，默认：China Standard Time
     */
    public $TimeZone;

    /**
     * @var boolean 是否跨AZ
     */
    public $IsDrZone;

    /**
     * @var SlaveZones 双节点实例备可用区信息
     */
    public $SlaveZones;

    /**
     * @var string 架构标识，SINGLE-单节点 DOUBLE-双节点
     */
    public $Architecture;

    /**
     * @var string 类型标识，EXCLUSIVE-独享型，SHARED-共享型
     */
    public $Style;

    /**
     * @var array 多节点实例备可用区信息
     */
    public $MultiSlaveZones;

    /**
     * @param string $InstanceId 实例ID
     * @param string $Name 实例名称
     * @param integer $ProjectId 实例所在项目ID
     * @param integer $RegionId 实例所在地域ID
     * @param integer $ZoneId 实例所在可用区ID
     * @param integer $VpcId 实例所在私有网络ID，基础网络时为 0
     * @param integer $SubnetId 实例所在私有网络子网ID，基础网络时为 0
     * @param integer $Status 实例状态。取值范围： <li>1：申请中</li> <li>2：运行中</li> <li>3：受限运行中 (主备切换中)</li> <li>4：已隔离</li> <li>5：回收中</li> <li>6：已回收</li> <li>7：任务执行中 (实例做备份、回档等操作)</li> <li>8：已下线</li> <li>9：实例扩容中</li> <li>10：实例迁移中</li> <li>11：只读</li> <li>12：重启中</li>  <li>13：实例修改中且待切换</li> <li>14：订阅发布创建中</li> <li>15：订阅发布修改中</li> <li>16：实例修改中且切换中</li> <li>17：创建RO副本中</li>
     * @param string $Vip 实例访问IP
     * @param integer $Vport 实例访问端口
     * @param string $CreateTime 实例创建时间
     * @param string $UpdateTime 实例更新时间
     * @param string $StartTime 实例计费开始时间
     * @param string $EndTime 实例计费结束时间
     * @param string $IsolateTime 实例隔离时间
     * @param integer $Memory 实例内存大小，单位G
     * @param integer $UsedStorage 实例已经使用存储空间大小，单位G
     * @param integer $Storage 实例存储空间大小，单位G
     * @param string $VersionName 实例版本
     * @param integer $RenewFlag 实例续费标记，0-正常续费，1-自动续费，2-到期不续费
     * @param integer $Model 实例高可用， 1-双机高可用，2-单机，3-跨可用区，4-集群跨可用区，5-集群，6-多节点集群，7-多节点集群跨可用区，9-自研机房
     * @param string $Region 实例所在地域名称，如 ap-guangzhou
     * @param string $Zone 实例所在可用区名称，如 ap-guangzhou-1
     * @param string $BackupTime 备份时间点
     * @param integer $PayMode 实例付费模式， 0-按量计费，1-包年包月
     * @param string $Uid 实例唯一UID
     * @param integer $Cpu 实例cpu核心数
     * @param string $Version 实例版本代号
     * @param string $Type 实例类型代号："TS85"-物理机，本地SSD硬盘；"Z3"-物理机早期版本，本地SSD硬盘；"CLOUD_BASIC"-虚拟机，普通云硬盘；"CLOUD_PREMIUM"-虚拟机，高性能云硬盘；"CLOUD_SSD"-虚拟机，云SSD硬盘；"CLOUD_HSSD"-虚拟机，增强型SSD云硬盘；"CLOUD_TSSD"-虚拟机，极速型SSD云硬盘；"CLOUD_BSSD"-虚拟机，通用型SSD云硬盘
     * @param integer $Pid 计费ID
     * @param string $UniqVpcId 实例所属VPC的唯一字符串ID，格式如：vpc-xxx，基础网络时为空字符串
     * @param string $UniqSubnetId 实例所属子网的唯一字符串ID，格式如： subnet-xxx，基础网络时为空字符串
     * @param string $IsolateOperator 实例隔离操作
     * @param string $SubFlag 发布订阅标识，SUB-订阅实例，PUB-发布实例，空值-没有发布订阅的普通实例
     * @param string $ROFlag 只读标识，RO-只读实例，MASTER-有RO实例的主实例，空值-没有只读组的非RO实例
     * @param string $HAFlag 容灾类型，MIRROR-镜像，ALWAYSON-AlwaysOn, SINGLE-单例
     * @param array $ResourceTags 实例绑定的标签列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $BackupModel 备份模式，master_pkg-主节点打包备份(默认) ；master_no_pkg-主节点不打包备份；slave_pkg-从节点打包备份(always on集群有效)；slave_no_pkg-从节点不打包备份(always on集群有效)；只读副本对该值无效。
     * @param string $InstanceNote 实例备份信息
     * @param array $BackupCycle 备份周期
     * @param string $BackupCycleType 备份周期类型，[daily、weekly、monthly]
     * @param integer $BackupSaveDays 数据(日志)备份保留时间
     * @param string $InstanceType 实例类型 HA-高可用，RO-只读实例，SI-基础版，BI-商业智能服务，cvmHA-云盘高可用，cvmRO-云盘只读实例，MultiHA-多节点，cvmMultiHA-云盘多节点

     * @param array $CrossRegions 跨地域备份目的地域，如果为空，则表示未开启跨地域备份
     * @param string $CrossBackupEnabled 跨地域备份状态 enable-开启，disable-关闭
     * @param integer $CrossBackupSaveDays 跨地域备份保留天数，则默认7天
     * @param string $DnsPodDomain 外网地址域名
     * @param integer $TgwWanVPort 外网端口号
     * @param string $Collation 系统字符集排序规则，默认：Chinese_PRC_CI_AS
     * @param string $TimeZone 系统时区，默认：China Standard Time
     * @param boolean $IsDrZone 是否跨AZ
     * @param SlaveZones $SlaveZones 双节点实例备可用区信息
     * @param string $Architecture 架构标识，SINGLE-单节点 DOUBLE-双节点
     * @param string $Style 类型标识，EXCLUSIVE-独享型，SHARED-共享型
     * @param array $MultiSlaveZones 多节点实例备可用区信息
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("InstanceId",$param) and $param["InstanceId"] !== null) {
            $this->InstanceId = $param["InstanceId"];
        }

        if (array_key_exists("Name",$param) and $param["Name"] !== null) {
            $this->Name = $param["Name"];
        }

        if (array_key_exists("ProjectId",$param) and $param["ProjectId"] !== null) {
            $this->ProjectId = $param["ProjectId"];
        }

        if (array_key_exists("RegionId",$param) and $param["RegionId"] !== null) {
            $this->RegionId = $param["RegionId"];
        }

        if (array_key_exists("ZoneId",$param) and $param["ZoneId"] !== null) {
            $this->ZoneId = $param["ZoneId"];
        }

        if (array_key_exists("VpcId",$param) and $param["VpcId"] !== null) {
            $this->VpcId = $param["VpcId"];
        }

        if (array_key_exists("SubnetId",$param) and $param["SubnetId"] !== null) {
            $this->SubnetId = $param["SubnetId"];
        }

        if (array_key_exists("Status",$param) and $param["Status"] !== null) {
            $this->Status = $param["Status"];
        }

        if (array_key_exists("Vip",$param) and $param["Vip"] !== null) {
            $this->Vip = $param["Vip"];
        }

        if (array_key_exists("Vport",$param) and $param["Vport"] !== null) {
            $this->Vport = $param["Vport"];
        }

        if (array_key_exists("CreateTime",$param) and $param["CreateTime"] !== null) {
            $this->CreateTime = $param["CreateTime"];
        }

        if (array_key_exists("UpdateTime",$param) and $param["UpdateTime"] !== null) {
            $this->UpdateTime = $param["UpdateTime"];
        }

        if (array_key_exists("StartTime",$param) and $param["StartTime"] !== null) {
            $this->StartTime = $param["StartTime"];
        }

        if (array_key_exists("EndTime",$param) and $param["EndTime"] !== null) {
            $this->EndTime = $param["EndTime"];
        }

        if (array_key_exists("IsolateTime",$param) and $param["IsolateTime"] !== null) {
            $this->IsolateTime = $param["IsolateTime"];
        }

        if (array_key_exists("Memory",$param) and $param["Memory"] !== null) {
            $this->Memory = $param["Memory"];
        }

        if (array_key_exists("UsedStorage",$param) and $param["UsedStorage"] !== null) {
            $this->UsedStorage = $param["UsedStorage"];
        }

        if (array_key_exists("Storage",$param) and $param["Storage"] !== null) {
            $this->Storage = $param["Storage"];
        }

        if (array_key_exists("VersionName",$param) and $param["VersionName"] !== null) {
            $this->VersionName = $param["VersionName"];
        }

        if (array_key_exists("RenewFlag",$param) and $param["RenewFlag"] !== null) {
            $this->RenewFlag = $param["RenewFlag"];
        }

        if (array_key_exists("Model",$param) and $param["Model"] !== null) {
            $this->Model = $param["Model"];
        }

        if (array_key_exists("Region",$param) and $param["Region"] !== null) {
            $this->Region = $param["Region"];
        }

        if (array_key_exists("Zone",$param) and $param["Zone"] !== null) {
            $this->Zone = $param["Zone"];
        }

        if (array_key_exists("BackupTime",$param) and $param["BackupTime"] !== null) {
            $this->BackupTime = $param["BackupTime"];
        }

        if (array_key_exists("PayMode",$param) and $param["PayMode"] !== null) {
            $this->PayMode = $param["PayMode"];
        }

        if (array_key_exists("Uid",$param) and $param["Uid"] !== null) {
            $this->Uid = $param["Uid"];
        }

        if (array_key_exists("Cpu",$param) and $param["Cpu"] !== null) {
            $this->Cpu = $param["Cpu"];
        }

        if (array_key_exists("Version",$param) and $param["Version"] !== null) {
            $this->Version = $param["Version"];
        }

        if (array_key_exists("Type",$param) and $param["Type"] !== null) {
            $this->Type = $param["Type"];
        }

        if (array_key_exists("Pid",$param) and $param["Pid"] !== null) {
            $this->Pid = $param["Pid"];
        }

        if (array_key_exists("UniqVpcId",$param) and $param["UniqVpcId"] !== null) {
            $this->UniqVpcId = $param["UniqVpcId"];
        }

        if (array_key_exists("UniqSubnetId",$param) and $param["UniqSubnetId"] !== null) {
            $this->UniqSubnetId = $param["UniqSubnetId"];
        }

        if (array_key_exists("IsolateOperator",$param) and $param["IsolateOperator"] !== null) {
            $this->IsolateOperator = $param["IsolateOperator"];
        }

        if (array_key_exists("SubFlag",$param) and $param["SubFlag"] !== null) {
            $this->SubFlag = $param["SubFlag"];
        }

        if (array_key_exists("ROFlag",$param) and $param["ROFlag"] !== null) {
            $this->ROFlag = $param["ROFlag"];
        }

        if (array_key_exists("HAFlag",$param) and $param["HAFlag"] !== null) {
            $this->HAFlag = $param["HAFlag"];
        }

        if (array_key_exists("ResourceTags",$param) and $param["ResourceTags"] !== null) {
            $this->ResourceTags = [];
            foreach ($param["ResourceTags"] as $key => $value){
                $obj = new ResourceTag();
                $obj->deserialize($value);
                array_push($this->ResourceTags, $obj);
            }
        }

        if (array_key_exists("BackupModel",$param) and $param["BackupModel"] !== null) {
            $this->BackupModel = $param["BackupModel"];
        }

        if (array_key_exists("InstanceNote",$param) and $param["InstanceNote"] !== null) {
            $this->InstanceNote = $param["InstanceNote"];
        }

        if (array_key_exists("BackupCycle",$param) and $param["BackupCycle"] !== null) {
            $this->BackupCycle = $param["BackupCycle"];
        }

        if (array_key_exists("BackupCycleType",$param) and $param["BackupCycleType"] !== null) {
            $this->BackupCycleType = $param["BackupCycleType"];
        }

        if (array_key_exists("BackupSaveDays",$param) and $param["BackupSaveDays"] !== null) {
            $this->BackupSaveDays = $param["BackupSaveDays"];
        }

        if (array_key_exists("InstanceType",$param) and $param["InstanceType"] !== null) {
            $this->InstanceType = $param["InstanceType"];
        }

        if (array_key_exists("CrossRegions",$param) and $param["CrossRegions"] !== null) {
            $this->CrossRegions = $param["CrossRegions"];
        }

        if (array_key_exists("CrossBackupEnabled",$param) and $param["CrossBackupEnabled"] !== null) {
            $this->CrossBackupEnabled = $param["CrossBackupEnabled"];
        }

        if (array_key_exists("CrossBackupSaveDays",$param) and $param["CrossBackupSaveDays"] !== null) {
            $this->CrossBackupSaveDays = $param["CrossBackupSaveDays"];
        }

        if (array_key_exists("DnsPodDomain",$param) and $param["DnsPodDomain"] !== null) {
            $this->DnsPodDomain = $param["DnsPodDomain"];
        }

        if (array_key_exists("TgwWanVPort",$param) and $param["TgwWanVPort"] !== null) {
            $this->TgwWanVPort = $param["TgwWanVPort"];
        }

        if (array_key_exists("Collation",$param) and $param["Collation"] !== null) {
            $this->Collation = $param["Collation"];
        }

        if (array_key_exists("TimeZone",$param) and $param["TimeZone"] !== null) {
            $this->TimeZone = $param["TimeZone"];
        }

        if (array_key_exists("IsDrZone",$param) and $param["IsDrZone"] !== null) {
            $this->IsDrZone = $param["IsDrZone"];
        }

        if (array_key_exists("SlaveZones",$param) and $param["SlaveZones"] !== null) {
            $this->SlaveZones = new SlaveZones();
            $this->SlaveZones->deserialize($param["SlaveZones"]);
        }

        if (array_key_exists("Architecture",$param) and $param["Architecture"] !== null) {
            $this->Architecture = $param["Architecture"];
        }

        if (array_key_exists("Style",$param) and $param["Style"] !== null) {
            $this->Style = $param["Style"];
        }

        if (array_key_exists("MultiSlaveZones",$param) and $param["MultiSlaveZones"] !== null) {
            $this->MultiSlaveZones = [];
            foreach ($param["MultiSlaveZones"] as $key => $value){
                $obj = new SlaveZones();
                $obj->deserialize($value);
                array_push($this->MultiSlaveZones, $obj);
            }
        }
    }
}
