<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Mps\V20190612\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DisassociateSecurityGroup请求参数结构体
 *
 * @method string getId() 获取媒体传输安全组ID。
 * @method void setId(string $Id) 设置媒体传输安全组ID。
 * @method array getUnattachInOutInfos() 获取要解绑的输入输出信息列表。
 * @method void setUnattachInOutInfos(array $UnattachInOutInfos) 设置要解绑的输入输出信息列表。
 */
class DisassociateSecurityGroupRequest extends AbstractModel
{
    /**
     * @var string 媒体传输安全组ID。
     */
    public $Id;

    /**
     * @var array 要解绑的输入输出信息列表。
     */
    public $UnattachInOutInfos;

    /**
     * @param string $Id 媒体传输安全组ID。
     * @param array $UnattachInOutInfos 要解绑的输入输出信息列表。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("UnattachInOutInfos",$param) and $param["UnattachInOutInfos"] !== null) {
            $this->UnattachInOutInfos = [];
            foreach ($param["UnattachInOutInfos"] as $key => $value){
                $obj = new UnattachSecurityGroupInOutInfo();
                $obj->deserialize($value);
                array_push($this->UnattachInOutInfos, $obj);
            }
        }
    }
}
