<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Monitor\V20180724\Models;
use TencentCloud\Common\AbstractModel;

/**
 * prometheus配置
 *
 * @method string getName() 获取名称
 * @method void setName(string $Name) 设置名称
 * @method string getConfig() 获取配置内容
 * @method void setConfig(string $Config) 设置配置内容
 * @method string getTemplateId() 获取用于出参，如果该配置来至模板，则为模板id
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTemplateId(string $TemplateId) 设置用于出参，如果该配置来至模板，则为模板id
注意：此字段可能返回 null，表示取不到有效值。
 * @method Targets getTargets() 获取目标数
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTargets(Targets $Targets) 设置目标数
注意：此字段可能返回 null，表示取不到有效值。
 */
class PrometheusConfigItem extends AbstractModel
{
    /**
     * @var string 名称
     */
    public $Name;

    /**
     * @var string 配置内容
     */
    public $Config;

    /**
     * @var string 用于出参，如果该配置来至模板，则为模板id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $TemplateId;

    /**
     * @var Targets 目标数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Targets;

    /**
     * @param string $Name 名称
     * @param string $Config 配置内容
     * @param string $TemplateId 用于出参，如果该配置来至模板，则为模板id
注意：此字段可能返回 null，表示取不到有效值。
     * @param Targets $Targets 目标数
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Name",$param) and $param["Name"] !== null) {
            $this->Name = $param["Name"];
        }

        if (array_key_exists("Config",$param) and $param["Config"] !== null) {
            $this->Config = $param["Config"];
        }

        if (array_key_exists("TemplateId",$param) and $param["TemplateId"] !== null) {
            $this->TemplateId = $param["TemplateId"];
        }

        if (array_key_exists("Targets",$param) and $param["Targets"] !== null) {
            $this->Targets = new Targets();
            $this->Targets->deserialize($param["Targets"]);
        }
    }
}
