<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Lighthouse\V20200324\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 可用区详细信息
 *
 * @method string getZone() 获取可用区
 * @method void setZone(string $Zone) 设置可用区
 * @method string getZoneName() 获取可用区中文名称
 * @method void setZoneName(string $ZoneName) 设置可用区中文名称
 * @method string getInstanceDisplayLabel() 获取实例购买页可用区展示标签
 * @method void setInstanceDisplayLabel(string $InstanceDisplayLabel) 设置实例购买页可用区展示标签
 */
class ZoneInfo extends AbstractModel
{
    /**
     * @var string 可用区
     */
    public $Zone;

    /**
     * @var string 可用区中文名称
     */
    public $ZoneName;

    /**
     * @var string 实例购买页可用区展示标签
     */
    public $InstanceDisplayLabel;

    /**
     * @param string $Zone 可用区
     * @param string $ZoneName 可用区中文名称
     * @param string $InstanceDisplayLabel 实例购买页可用区展示标签
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Zone",$param) and $param["Zone"] !== null) {
            $this->Zone = $param["Zone"];
        }

        if (array_key_exists("ZoneName",$param) and $param["ZoneName"] !== null) {
            $this->ZoneName = $param["ZoneName"];
        }

        if (array_key_exists("InstanceDisplayLabel",$param) and $param["InstanceDisplayLabel"] !== null) {
            $this->InstanceDisplayLabel = $param["InstanceDisplayLabel"];
        }
    }
}
