<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Iss\V20230517\Models;
use TencentCloud\Common\AbstractModel;

/**
 * BatchDeleteVideoDownloadTask请求参数结构体
 *
 * @method array getDownloadTaskIds() 获取本地录像下载任务 ID 列表
 * @method void setDownloadTaskIds(array $DownloadTaskIds) 设置本地录像下载任务 ID 列表
 */
class BatchDeleteVideoDownloadTaskRequest extends AbstractModel
{
    /**
     * @var array 本地录像下载任务 ID 列表
     */
    public $DownloadTaskIds;

    /**
     * @param array $DownloadTaskIds 本地录像下载任务 ID 列表
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("DownloadTaskIds",$param) and $param["DownloadTaskIds"] !== null) {
            $this->DownloadTaskIds = $param["DownloadTaskIds"];
        }
    }
}
