<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ims\V20201229\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 用于返回OCR文本结果详情，图片中的文本越多，可能导致接口返回时间增加。
 *
 * @method string getText() 获取该字段用于返回OCR识别出的文本内容。<br>备注：OCR文本识别上限在**5000字节内**。
 * @method void setText(string $Text) 设置该字段用于返回OCR识别出的文本内容。<br>备注：OCR文本识别上限在**5000字节内**。
 * @method string getLabel() 获取该字段用于返回检测结果所对应的恶意标签。<br>返回值：**Normal**：正常，**Porn**：色情，**Abuse**：谩骂，**Ad**：广告；以及其他令人反感、不安全或不适宜的内容类型。
 * @method void setLabel(string $Label) 设置该字段用于返回检测结果所对应的恶意标签。<br>返回值：**Normal**：正常，**Porn**：色情，**Abuse**：谩骂，**Ad**：广告；以及其他令人反感、不安全或不适宜的内容类型。
 * @method string getLibId() 获取该字段用于返回自定义库的ID，以方便自定义库管理和配置。
 * @method void setLibId(string $LibId) 设置该字段用于返回自定义库的ID，以方便自定义库管理和配置。
 * @method string getLibName() 获取该字段用于返回自定义库的名称，以方便自定义库管理和配置。
 * @method void setLibName(string $LibName) 设置该字段用于返回自定义库的名称，以方便自定义库管理和配置。
 * @method array getKeywords() 获取该参数用于返回在当前label下命中的关键词。
 * @method void setKeywords(array $Keywords) 设置该参数用于返回在当前label下命中的关键词。
 * @method integer getScore() 获取该参数用于返回在当前恶意标签下模型命中的分值，取值为**0-100**；分数越高，代表当前场景越符合该恶意标签所对应的场景。
 * @method void setScore(integer $Score) 设置该参数用于返回在当前恶意标签下模型命中的分值，取值为**0-100**；分数越高，代表当前场景越符合该恶意标签所对应的场景。
 * @method Location getLocation() 获取该参数用于返回OCR检测框在图片中的位置（左上角xy坐标、长宽、旋转角度），以方便快速定位识别文字的相关信息。
 * @method void setLocation(Location $Location) 设置该参数用于返回OCR检测框在图片中的位置（左上角xy坐标、长宽、旋转角度），以方便快速定位识别文字的相关信息。
 * @method integer getRate() 获取该参数用于返回OCR文本识别结果的置信度，取值在**0**（**置信度最低**）-**100**（**置信度最高**），越高代表对应图像越有可能是识别出的文字；如：*你好 99*，则表明OCR识别框内的文字大概率是”你好“。
 * @method void setRate(integer $Rate) 设置该参数用于返回OCR文本识别结果的置信度，取值在**0**（**置信度最低**）-**100**（**置信度最高**），越高代表对应图像越有可能是识别出的文字；如：*你好 99*，则表明OCR识别框内的文字大概率是”你好“。
 * @method string getSubLabel() 获取该字段用于返回检测结果所对应的恶意二级标签。
 * @method void setSubLabel(string $SubLabel) 设置该字段用于返回检测结果所对应的恶意二级标签。
 * @method array getHitInfos() 获取关键词命中位置信息
 * @method void setHitInfos(array $HitInfos) 设置关键词命中位置信息
 */
class OcrTextDetail extends AbstractModel
{
    /**
     * @var string 该字段用于返回OCR识别出的文本内容。<br>备注：OCR文本识别上限在**5000字节内**。
     */
    public $Text;

    /**
     * @var string 该字段用于返回检测结果所对应的恶意标签。<br>返回值：**Normal**：正常，**Porn**：色情，**Abuse**：谩骂，**Ad**：广告；以及其他令人反感、不安全或不适宜的内容类型。
     */
    public $Label;

    /**
     * @var string 该字段用于返回自定义库的ID，以方便自定义库管理和配置。
     */
    public $LibId;

    /**
     * @var string 该字段用于返回自定义库的名称，以方便自定义库管理和配置。
     */
    public $LibName;

    /**
     * @var array 该参数用于返回在当前label下命中的关键词。
     */
    public $Keywords;

    /**
     * @var integer 该参数用于返回在当前恶意标签下模型命中的分值，取值为**0-100**；分数越高，代表当前场景越符合该恶意标签所对应的场景。
     */
    public $Score;

    /**
     * @var Location 该参数用于返回OCR检测框在图片中的位置（左上角xy坐标、长宽、旋转角度），以方便快速定位识别文字的相关信息。
     */
    public $Location;

    /**
     * @var integer 该参数用于返回OCR文本识别结果的置信度，取值在**0**（**置信度最低**）-**100**（**置信度最高**），越高代表对应图像越有可能是识别出的文字；如：*你好 99*，则表明OCR识别框内的文字大概率是”你好“。
     */
    public $Rate;

    /**
     * @var string 该字段用于返回检测结果所对应的恶意二级标签。
     */
    public $SubLabel;

    /**
     * @var array 关键词命中位置信息
     */
    public $HitInfos;

    /**
     * @param string $Text 该字段用于返回OCR识别出的文本内容。<br>备注：OCR文本识别上限在**5000字节内**。
     * @param string $Label 该字段用于返回检测结果所对应的恶意标签。<br>返回值：**Normal**：正常，**Porn**：色情，**Abuse**：谩骂，**Ad**：广告；以及其他令人反感、不安全或不适宜的内容类型。
     * @param string $LibId 该字段用于返回自定义库的ID，以方便自定义库管理和配置。
     * @param string $LibName 该字段用于返回自定义库的名称，以方便自定义库管理和配置。
     * @param array $Keywords 该参数用于返回在当前label下命中的关键词。
     * @param integer $Score 该参数用于返回在当前恶意标签下模型命中的分值，取值为**0-100**；分数越高，代表当前场景越符合该恶意标签所对应的场景。
     * @param Location $Location 该参数用于返回OCR检测框在图片中的位置（左上角xy坐标、长宽、旋转角度），以方便快速定位识别文字的相关信息。
     * @param integer $Rate 该参数用于返回OCR文本识别结果的置信度，取值在**0**（**置信度最低**）-**100**（**置信度最高**），越高代表对应图像越有可能是识别出的文字；如：*你好 99*，则表明OCR识别框内的文字大概率是”你好“。
     * @param string $SubLabel 该字段用于返回检测结果所对应的恶意二级标签。
     * @param array $HitInfos 关键词命中位置信息
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Text",$param) and $param["Text"] !== null) {
            $this->Text = $param["Text"];
        }

        if (array_key_exists("Label",$param) and $param["Label"] !== null) {
            $this->Label = $param["Label"];
        }

        if (array_key_exists("LibId",$param) and $param["LibId"] !== null) {
            $this->LibId = $param["LibId"];
        }

        if (array_key_exists("LibName",$param) and $param["LibName"] !== null) {
            $this->LibName = $param["LibName"];
        }

        if (array_key_exists("Keywords",$param) and $param["Keywords"] !== null) {
            $this->Keywords = $param["Keywords"];
        }

        if (array_key_exists("Score",$param) and $param["Score"] !== null) {
            $this->Score = $param["Score"];
        }

        if (array_key_exists("Location",$param) and $param["Location"] !== null) {
            $this->Location = new Location();
            $this->Location->deserialize($param["Location"]);
        }

        if (array_key_exists("Rate",$param) and $param["Rate"] !== null) {
            $this->Rate = $param["Rate"];
        }

        if (array_key_exists("SubLabel",$param) and $param["SubLabel"] !== null) {
            $this->SubLabel = $param["SubLabel"];
        }

        if (array_key_exists("HitInfos",$param) and $param["HitInfos"] !== null) {
            $this->HitInfos = [];
            foreach ($param["HitInfos"] as $key => $value){
                $obj = new OcrHitInfo();
                $obj->deserialize($value);
                array_push($this->HitInfos, $obj);
            }
        }
    }
}
