<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Iecp\V20210914\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeSecret请求参数结构体
 *
 * @method integer getEdgeUnitID() 获取边缘单元ID
 * @method void setEdgeUnitID(integer $EdgeUnitID) 设置边缘单元ID
 * @method string getSecretName() 获取secret名
 * @method void setSecretName(string $SecretName) 设置secret名
 * @method string getSecretNamespace() 获取命名空间(默认值:default）
 * @method void setSecretNamespace(string $SecretNamespace) 设置命名空间(默认值:default）
 */
class DescribeSecretRequest extends AbstractModel
{
    /**
     * @var integer 边缘单元ID
     */
    public $EdgeUnitID;

    /**
     * @var string secret名
     */
    public $SecretName;

    /**
     * @var string 命名空间(默认值:default）
     */
    public $SecretNamespace;

    /**
     * @param integer $EdgeUnitID 边缘单元ID
     * @param string $SecretName secret名
     * @param string $SecretNamespace 命名空间(默认值:default）
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("EdgeUnitID",$param) and $param["EdgeUnitID"] !== null) {
            $this->EdgeUnitID = $param["EdgeUnitID"];
        }

        if (array_key_exists("SecretName",$param) and $param["SecretName"] !== null) {
            $this->SecretName = $param["SecretName"];
        }

        if (array_key_exists("SecretNamespace",$param) and $param["SecretNamespace"] !== null) {
            $this->SecretNamespace = $param["SecretNamespace"];
        }
    }
}
