<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Iai\V20200303\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 五官遮挡分，评价眉毛（Eyebrow）、眼睛（Eye）、鼻子（Nose）、脸颊（Cheek）、嘴巴（Mouth）、下巴（Chin）的被遮挡程度。
 *
 * @method integer getEyebrow() 获取眉毛的遮挡分数。
- 取值范围：[0,100]，分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setEyebrow(integer $Eyebrow) 设置眉毛的遮挡分数。
- 取值范围：[0,100]，分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getEye() 获取眼睛的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setEye(integer $Eye) 设置眼睛的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getNose() 获取鼻子的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,60]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setNose(integer $Nose) 设置鼻子的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,60]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getCheek() 获取脸颊的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCheek(integer $Cheek) 设置脸颊的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getMouth() 获取嘴巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,50]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setMouth(integer $Mouth) 设置嘴巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,50]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getChin() 获取下巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setChin(integer $Chin) 设置下巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
 */
class FaceQualityCompleteness extends AbstractModel
{
    /**
     * @var integer 眉毛的遮挡分数。
- 取值范围：[0,100]，分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Eyebrow;

    /**
     * @var integer 眼睛的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Eye;

    /**
     * @var integer 鼻子的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,60]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Nose;

    /**
     * @var integer 脸颊的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Cheek;

    /**
     * @var integer 嘴巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,50]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Mouth;

    /**
     * @var integer 下巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Chin;

    /**
     * @param integer $Eyebrow 眉毛的遮挡分数。
- 取值范围：[0,100]，分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Eye 眼睛的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,80]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Nose 鼻子的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,60]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Cheek 脸颊的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Mouth 嘴巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,50]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Chin 下巴的遮挡分数。
- 取值范围：[0,100],分数越高遮挡越少。 
- 参考范围：[0,70]表示发生遮挡。
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Eyebrow",$param) and $param["Eyebrow"] !== null) {
            $this->Eyebrow = $param["Eyebrow"];
        }

        if (array_key_exists("Eye",$param) and $param["Eye"] !== null) {
            $this->Eye = $param["Eye"];
        }

        if (array_key_exists("Nose",$param) and $param["Nose"] !== null) {
            $this->Nose = $param["Nose"];
        }

        if (array_key_exists("Cheek",$param) and $param["Cheek"] !== null) {
            $this->Cheek = $param["Cheek"];
        }

        if (array_key_exists("Mouth",$param) and $param["Mouth"] !== null) {
            $this->Mouth = $param["Mouth"];
        }

        if (array_key_exists("Chin",$param) and $param["Chin"] !== null) {
            $this->Chin = $param["Chin"];
        }
    }
}
