<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Iai\V20200303\Models;
use TencentCloud\Common\AbstractModel;

/**
 * CompareMaskFace请求参数结构体
 *
 * @method string getImageA() 获取A 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method void setImageA(string $ImageA) 设置A 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method string getImageB() 获取B 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method void setImageB(string $ImageB) 设置B 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method string getUrlA() 获取A 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- A 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method void setUrlA(string $UrlA) 设置A 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- A 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method string getUrlB() 获取B 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- B 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method void setUrlB(string $UrlB) 设置B 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- B 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
 * @method string getFaceModelVersion() 获取人脸识别服务所用的算法模型版本。该接口只支持"3.0"
 * @method void setFaceModelVersion(string $FaceModelVersion) 设置人脸识别服务所用的算法模型版本。该接口只支持"3.0"
 * @method integer getQualityControl() 获取图片质量控制。 
- 取值范围：
0: 不进行控制； 
1:较低的质量要求，图像存在非常模糊，眼睛鼻子嘴巴遮挡至少其中一种或多种的情况； 
2: 一般的质量要求，图像存在偏亮，偏暗，模糊或一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，至少其中三种的情况； 
3: 较高的质量要求，图像存在偏亮，偏暗，一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，其中一到两种的情况； 
4: 很高的质量要求，各个维度均为最好或最多在某一维度上存在轻微问题； 
- 默认 0。 
- 若图片质量不满足要求，则返回结果中会提示图片质量检测不符要求。
 * @method void setQualityControl(integer $QualityControl) 设置图片质量控制。 
- 取值范围：
0: 不进行控制； 
1:较低的质量要求，图像存在非常模糊，眼睛鼻子嘴巴遮挡至少其中一种或多种的情况； 
2: 一般的质量要求，图像存在偏亮，偏暗，模糊或一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，至少其中三种的情况； 
3: 较高的质量要求，图像存在偏亮，偏暗，一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，其中一到两种的情况； 
4: 很高的质量要求，各个维度均为最好或最多在某一维度上存在轻微问题； 
- 默认 0。 
- 若图片质量不满足要求，则返回结果中会提示图片质量检测不符要求。
 */
class CompareMaskFaceRequest extends AbstractModel
{
    /**
     * @var string A 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     */
    public $ImageA;

    /**
     * @var string B 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     */
    public $ImageB;

    /**
     * @var string A 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- A 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     */
    public $UrlA;

    /**
     * @var string B 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- B 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     */
    public $UrlB;

    /**
     * @var string 人脸识别服务所用的算法模型版本。该接口只支持"3.0"
     */
    public $FaceModelVersion;

    /**
     * @var integer 图片质量控制。 
- 取值范围：
0: 不进行控制； 
1:较低的质量要求，图像存在非常模糊，眼睛鼻子嘴巴遮挡至少其中一种或多种的情况； 
2: 一般的质量要求，图像存在偏亮，偏暗，模糊或一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，至少其中三种的情况； 
3: 较高的质量要求，图像存在偏亮，偏暗，一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，其中一到两种的情况； 
4: 很高的质量要求，各个维度均为最好或最多在某一维度上存在轻微问题； 
- 默认 0。 
- 若图片质量不满足要求，则返回结果中会提示图片质量检测不符要求。
     */
    public $QualityControl;

    /**
     * @param string $ImageA A 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     * @param string $ImageB B 图片 base64 数据。
- base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     * @param string $UrlA A 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- A 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     * @param string $UrlB B 图片的 Url 。
- 对应图片 base64 编码后大小不可超过5M。
- jpg格式长边像素不可超过4000，其他格式图片长边像素不可超2000。所有格式的图片短边像素不小于64。
- B 图片的 Url、Image必须提供一个，如果都提供，只使用 Url。 
- 图片存储于腾讯云的Url可保障更高下载速度和稳定性，建议图片存储于腾讯云。 
- 非腾讯云存储的Url速度和稳定性可能受一定影响。
- 若图片中包含多张人脸，只选取其中人脸面积最大的人脸。
- 支持PNG、JPG、JPEG、BMP，不支持 GIF 图片。
     * @param string $FaceModelVersion 人脸识别服务所用的算法模型版本。该接口只支持"3.0"
     * @param integer $QualityControl 图片质量控制。 
- 取值范围：
0: 不进行控制； 
1:较低的质量要求，图像存在非常模糊，眼睛鼻子嘴巴遮挡至少其中一种或多种的情况； 
2: 一般的质量要求，图像存在偏亮，偏暗，模糊或一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，至少其中三种的情况； 
3: 较高的质量要求，图像存在偏亮，偏暗，一般模糊，眉毛遮挡，脸颊遮挡，下巴遮挡，其中一到两种的情况； 
4: 很高的质量要求，各个维度均为最好或最多在某一维度上存在轻微问题； 
- 默认 0。 
- 若图片质量不满足要求，则返回结果中会提示图片质量检测不符要求。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ImageA",$param) and $param["ImageA"] !== null) {
            $this->ImageA = $param["ImageA"];
        }

        if (array_key_exists("ImageB",$param) and $param["ImageB"] !== null) {
            $this->ImageB = $param["ImageB"];
        }

        if (array_key_exists("UrlA",$param) and $param["UrlA"] !== null) {
            $this->UrlA = $param["UrlA"];
        }

        if (array_key_exists("UrlB",$param) and $param["UrlB"] !== null) {
            $this->UrlB = $param["UrlB"];
        }

        if (array_key_exists("FaceModelVersion",$param) and $param["FaceModelVersion"] !== null) {
            $this->FaceModelVersion = $param["FaceModelVersion"];
        }

        if (array_key_exists("QualityControl",$param) and $param["QualityControl"] !== null) {
            $this->QualityControl = $param["QualityControl"];
        }
    }
}
