<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ess\V20201111\Models;
use TencentCloud\Common\AbstractModel;

/**
 * CreateMultiFlowSignQRCode返回参数结构体
 *
 * @method SignQrCode getQrCode() 获取一码多签签署码的基本信息，用户可扫描该二维码进行签署操作。
 * @method void setQrCode(SignQrCode $QrCode) 设置一码多签签署码的基本信息，用户可扫描该二维码进行签署操作。
 * @method SignUrl getSignUrls() 获取一码多签签署码的链接信息，适用于客户系统整合二维码功能。通过链接，用户可直接访问电子签名小程序并签署合同。
 * @method void setSignUrls(SignUrl $SignUrls) 设置一码多签签署码的链接信息，适用于客户系统整合二维码功能。通过链接，用户可直接访问电子签名小程序并签署合同。
 * @method string getRequestId() 获取唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 */
class CreateMultiFlowSignQRCodeResponse extends AbstractModel
{
    /**
     * @var SignQrCode 一码多签签署码的基本信息，用户可扫描该二维码进行签署操作。
     */
    public $QrCode;

    /**
     * @var SignUrl 一码多签签署码的链接信息，适用于客户系统整合二维码功能。通过链接，用户可直接访问电子签名小程序并签署合同。
     */
    public $SignUrls;

    /**
     * @var string 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param SignQrCode $QrCode 一码多签签署码的基本信息，用户可扫描该二维码进行签署操作。
     * @param SignUrl $SignUrls 一码多签签署码的链接信息，适用于客户系统整合二维码功能。通过链接，用户可直接访问电子签名小程序并签署合同。
     * @param string $RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("QrCode",$param) and $param["QrCode"] !== null) {
            $this->QrCode = new SignQrCode();
            $this->QrCode->deserialize($param["QrCode"]);
        }

        if (array_key_exists("SignUrls",$param) and $param["SignUrls"] !== null) {
            $this->SignUrls = new SignUrl();
            $this->SignUrls->deserialize($param["SignUrls"]);
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
