<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Es\V20180416\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeClusterSnapshot返回参数结构体
 *
 * @method string getInstanceId() 获取集群实例Id，格式：es-xxxx
 * @method void setInstanceId(string $InstanceId) 设置集群实例Id，格式：es-xxxx
 * @method array getSnapshots() 获取快照备份详情列表
 * @method void setSnapshots(array $Snapshots) 设置快照备份详情列表
 * @method string getRepositoryName() 获取快照仓库名称
 * @method void setRepositoryName(string $RepositoryName) 设置快照仓库名称
 * @method string getRequestId() 获取唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeClusterSnapshotResponse extends AbstractModel
{
    /**
     * @var string 集群实例Id，格式：es-xxxx
     */
    public $InstanceId;

    /**
     * @var array 快照备份详情列表
     */
    public $Snapshots;

    /**
     * @var string 快照仓库名称
     */
    public $RepositoryName;

    /**
     * @var string 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param string $InstanceId 集群实例Id，格式：es-xxxx
     * @param array $Snapshots 快照备份详情列表
     * @param string $RepositoryName 快照仓库名称
     * @param string $RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("InstanceId",$param) and $param["InstanceId"] !== null) {
            $this->InstanceId = $param["InstanceId"];
        }

        if (array_key_exists("Snapshots",$param) and $param["Snapshots"] !== null) {
            $this->Snapshots = [];
            foreach ($param["Snapshots"] as $key => $value){
                $obj = new Snapshots();
                $obj->deserialize($value);
                array_push($this->Snapshots, $obj);
            }
        }

        if (array_key_exists("RepositoryName",$param) and $param["RepositoryName"] !== null) {
            $this->RepositoryName = $param["RepositoryName"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
