<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Emr\V20190103\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeInspectionTaskResult返回参数结构体
 *
 * @method string getInspectionResultInfo() 获取巡检任务记录，base64编码
 * @method void setInspectionResultInfo(string $InspectionResultInfo) 设置巡检任务记录，base64编码
 * @method integer getTotal() 获取记录总数
 * @method void setTotal(integer $Total) 设置记录总数
 * @method string getTypeInfo() 获取类别信息，base64编码，{"FixedTime": "定时", "RealTime": "及时"}
 * @method void setTypeInfo(string $TypeInfo) 设置类别信息，base64编码，{"FixedTime": "定时", "RealTime": "及时"}
 * @method string getRequestId() 获取唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeInspectionTaskResultResponse extends AbstractModel
{
    /**
     * @var string 巡检任务记录，base64编码
     */
    public $InspectionResultInfo;

    /**
     * @var integer 记录总数
     */
    public $Total;

    /**
     * @var string 类别信息，base64编码，{"FixedTime": "定时", "RealTime": "及时"}
     */
    public $TypeInfo;

    /**
     * @var string 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param string $InspectionResultInfo 巡检任务记录，base64编码
     * @param integer $Total 记录总数
     * @param string $TypeInfo 类别信息，base64编码，{"FixedTime": "定时", "RealTime": "及时"}
     * @param string $RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("InspectionResultInfo",$param) and $param["InspectionResultInfo"] !== null) {
            $this->InspectionResultInfo = $param["InspectionResultInfo"];
        }

        if (array_key_exists("Total",$param) and $param["Total"] !== null) {
            $this->Total = $param["Total"];
        }

        if (array_key_exists("TypeInfo",$param) and $param["TypeInfo"] !== null) {
            $this->TypeInfo = $param["TypeInfo"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
