<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Dts\V20211206\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 迁移对象选项，需要告知迁移服务迁移哪些库表对象
 *
 * @method string getObjectMode() 获取迁移对象类型 all(全实例)，partial(部分对象)
 * @method void setObjectMode(string $ObjectMode) 设置迁移对象类型 all(全实例)，partial(部分对象)
 * @method array getDatabases() 获取迁移对象，当 ObjectMode 为 partial 时，不为空
 * @method void setDatabases(array $Databases) 设置迁移对象，当 ObjectMode 为 partial 时，不为空
 * @method array getAdvancedObjects() 获取高级对象类型，如trigger、function、procedure、event。注意：如果要迁移同步高级对象，此配置中应该包含对应的高级对象类型
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setAdvancedObjects(array $AdvancedObjects) 设置高级对象类型，如trigger、function、procedure、event。注意：如果要迁移同步高级对象，此配置中应该包含对应的高级对象类型
注意：此字段可能返回 null，表示取不到有效值。
 */
class DatabaseTableObject extends AbstractModel
{
    /**
     * @var string 迁移对象类型 all(全实例)，partial(部分对象)
     */
    public $ObjectMode;

    /**
     * @var array 迁移对象，当 ObjectMode 为 partial 时，不为空
     */
    public $Databases;

    /**
     * @var array 高级对象类型，如trigger、function、procedure、event。注意：如果要迁移同步高级对象，此配置中应该包含对应的高级对象类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $AdvancedObjects;

    /**
     * @param string $ObjectMode 迁移对象类型 all(全实例)，partial(部分对象)
     * @param array $Databases 迁移对象，当 ObjectMode 为 partial 时，不为空
     * @param array $AdvancedObjects 高级对象类型，如trigger、function、procedure、event。注意：如果要迁移同步高级对象，此配置中应该包含对应的高级对象类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ObjectMode",$param) and $param["ObjectMode"] !== null) {
            $this->ObjectMode = $param["ObjectMode"];
        }

        if (array_key_exists("Databases",$param) and $param["Databases"] !== null) {
            $this->Databases = [];
            foreach ($param["Databases"] as $key => $value){
                $obj = new DBItem();
                $obj->deserialize($value);
                array_push($this->Databases, $obj);
            }
        }

        if (array_key_exists("AdvancedObjects",$param) and $param["AdvancedObjects"] !== null) {
            $this->AdvancedObjects = $param["AdvancedObjects"];
        }
    }
}
