<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Dts\V20211206\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 一致性校验库表对象
 *
 * @method string getDbName() 获取数据库名
 * @method void setDbName(string $DbName) 设置数据库名
 * @method string getDbMode() 获取数据库选择模式: all 为当前对象下的所有对象,partial 为部分对象
 * @method void setDbMode(string $DbMode) 设置数据库选择模式: all 为当前对象下的所有对象,partial 为部分对象
 * @method string getSchemaName() 获取schema名称
 * @method void setSchemaName(string $SchemaName) 设置schema名称
 * @method string getTableMode() 获取表选择模式: all 为当前对象下的所有表对象,partial 为部分表对象
 * @method void setTableMode(string $TableMode) 设置表选择模式: all 为当前对象下的所有表对象,partial 为部分表对象
 * @method array getTables() 获取用于一致性校验的表配置，当 TableMode 为 partial 时，需要填写
 * @method void setTables(array $Tables) 设置用于一致性校验的表配置，当 TableMode 为 partial 时，需要填写
 * @method string getViewMode() 获取视图选择模式: all 为当前对象下的所有视图对象,partial 为部分视图对象(一致性校验不校验视图，当前参数未启作用)
 * @method void setViewMode(string $ViewMode) 设置视图选择模式: all 为当前对象下的所有视图对象,partial 为部分视图对象(一致性校验不校验视图，当前参数未启作用)
 * @method array getViews() 获取用于一致性校验的视图配置，当 ViewMode 为 partial 时， 需要填写(一致性校验不校验视图，当前参数未启作用)
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setViews(array $Views) 设置用于一致性校验的视图配置，当 ViewMode 为 partial 时， 需要填写(一致性校验不校验视图，当前参数未启作用)
注意：此字段可能返回 null，表示取不到有效值。
 */
class CompareObjectItem extends AbstractModel
{
    /**
     * @var string 数据库名
     */
    public $DbName;

    /**
     * @var string 数据库选择模式: all 为当前对象下的所有对象,partial 为部分对象
     */
    public $DbMode;

    /**
     * @var string schema名称
     */
    public $SchemaName;

    /**
     * @var string 表选择模式: all 为当前对象下的所有表对象,partial 为部分表对象
     */
    public $TableMode;

    /**
     * @var array 用于一致性校验的表配置，当 TableMode 为 partial 时，需要填写
     */
    public $Tables;

    /**
     * @var string 视图选择模式: all 为当前对象下的所有视图对象,partial 为部分视图对象(一致性校验不校验视图，当前参数未启作用)
     */
    public $ViewMode;

    /**
     * @var array 用于一致性校验的视图配置，当 ViewMode 为 partial 时， 需要填写(一致性校验不校验视图，当前参数未启作用)
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Views;

    /**
     * @param string $DbName 数据库名
     * @param string $DbMode 数据库选择模式: all 为当前对象下的所有对象,partial 为部分对象
     * @param string $SchemaName schema名称
     * @param string $TableMode 表选择模式: all 为当前对象下的所有表对象,partial 为部分表对象
     * @param array $Tables 用于一致性校验的表配置，当 TableMode 为 partial 时，需要填写
     * @param string $ViewMode 视图选择模式: all 为当前对象下的所有视图对象,partial 为部分视图对象(一致性校验不校验视图，当前参数未启作用)
     * @param array $Views 用于一致性校验的视图配置，当 ViewMode 为 partial 时， 需要填写(一致性校验不校验视图，当前参数未启作用)
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("DbName",$param) and $param["DbName"] !== null) {
            $this->DbName = $param["DbName"];
        }

        if (array_key_exists("DbMode",$param) and $param["DbMode"] !== null) {
            $this->DbMode = $param["DbMode"];
        }

        if (array_key_exists("SchemaName",$param) and $param["SchemaName"] !== null) {
            $this->SchemaName = $param["SchemaName"];
        }

        if (array_key_exists("TableMode",$param) and $param["TableMode"] !== null) {
            $this->TableMode = $param["TableMode"];
        }

        if (array_key_exists("Tables",$param) and $param["Tables"] !== null) {
            $this->Tables = [];
            foreach ($param["Tables"] as $key => $value){
                $obj = new CompareTableItem();
                $obj->deserialize($value);
                array_push($this->Tables, $obj);
            }
        }

        if (array_key_exists("ViewMode",$param) and $param["ViewMode"] !== null) {
            $this->ViewMode = $param["ViewMode"];
        }

        if (array_key_exists("Views",$param) and $param["Views"] !== null) {
            $this->Views = [];
            foreach ($param["Views"] as $key => $value){
                $obj = new CompareViewItem();
                $obj->deserialize($value);
                array_push($this->Views, $obj);
            }
        }
    }
}
