<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cynosdb\V20190107\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 任务信息
 *
 * @method integer getTaskId() 获取任务自增ID
 * @method void setTaskId(integer $TaskId) 设置任务自增ID
 * @method string getTaskType() 获取任务类型
 * @method void setTaskType(string $TaskType) 设置任务类型
 * @method string getTaskStatus() 获取任务状态
 * @method void setTaskStatus(string $TaskStatus) 设置任务状态
 * @method string getObjectId() 获取任务ID（集群ID|实例组ID|实例ID）
 * @method void setObjectId(string $ObjectId) 设置任务ID（集群ID|实例组ID|实例ID）
 * @method string getObjectType() 获取任务类型
 * @method void setObjectType(string $ObjectType) 设置任务类型
 */
class ObjectTask extends AbstractModel
{
    /**
     * @var integer 任务自增ID
     */
    public $TaskId;

    /**
     * @var string 任务类型
     */
    public $TaskType;

    /**
     * @var string 任务状态
     */
    public $TaskStatus;

    /**
     * @var string 任务ID（集群ID|实例组ID|实例ID）
     */
    public $ObjectId;

    /**
     * @var string 任务类型
     */
    public $ObjectType;

    /**
     * @param integer $TaskId 任务自增ID
     * @param string $TaskType 任务类型
     * @param string $TaskStatus 任务状态
     * @param string $ObjectId 任务ID（集群ID|实例组ID|实例ID）
     * @param string $ObjectType 任务类型
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("TaskId",$param) and $param["TaskId"] !== null) {
            $this->TaskId = $param["TaskId"];
        }

        if (array_key_exists("TaskType",$param) and $param["TaskType"] !== null) {
            $this->TaskType = $param["TaskType"];
        }

        if (array_key_exists("TaskStatus",$param) and $param["TaskStatus"] !== null) {
            $this->TaskStatus = $param["TaskStatus"];
        }

        if (array_key_exists("ObjectId",$param) and $param["ObjectId"] !== null) {
            $this->ObjectId = $param["ObjectId"];
        }

        if (array_key_exists("ObjectType",$param) and $param["ObjectType"] !== null) {
            $this->ObjectType = $param["ObjectType"];
        }
    }
}
