<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ModifyMalwareWhiteList请求参数结构体
 *
 * @method integer getMode() 获取白名单模式； 0MD5白名单，1自定义
 * @method void setMode(integer $Mode) 设置白名单模式； 0MD5白名单，1自定义
 * @method integer getId() 获取规则唯一ID
 * @method void setId(integer $Id) 设置规则唯一ID
 * @method array getQuuidList() 获取quuid 列表
 * @method void setQuuidList(array $QuuidList) 设置quuid 列表
 * @method integer getIsGlobal() 获取是否全部主机； 0否，1是。
 * @method void setIsGlobal(integer $IsGlobal) 设置是否全部主机； 0否，1是。
 * @method integer getMatchType() 获取匹配模式 ；0 精确匹配，1模糊匹配(废弃)
 * @method void setMatchType(integer $MatchType) 设置匹配模式 ；0 精确匹配，1模糊匹配(废弃)
 * @method array getFileName() 获取文件名称(正则)；长度不超过200个
 * @method void setFileName(array $FileName) 设置文件名称(正则)；长度不超过200个
 * @method array getFileDirectory() 获取文件目录(正则)；长度不超过200个，内容base64转义
 * @method void setFileDirectory(array $FileDirectory) 设置文件目录(正则)；长度不超过200个，内容base64转义
 * @method array getFileExtension() 获取文件后缀；长度不超过200个，内容base64转义（废弃）
 * @method void setFileExtension(array $FileExtension) 设置文件后缀；长度不超过200个，内容base64转义（废弃）
 * @method array getMd5List() 获取MD5列表
 * @method void setMd5List(array $Md5List) 设置MD5列表
 */
class ModifyMalwareWhiteListRequest extends AbstractModel
{
    /**
     * @var integer 白名单模式； 0MD5白名单，1自定义
     */
    public $Mode;

    /**
     * @var integer 规则唯一ID
     */
    public $Id;

    /**
     * @var array quuid 列表
     */
    public $QuuidList;

    /**
     * @var integer 是否全部主机； 0否，1是。
     */
    public $IsGlobal;

    /**
     * @var integer 匹配模式 ；0 精确匹配，1模糊匹配(废弃)
     */
    public $MatchType;

    /**
     * @var array 文件名称(正则)；长度不超过200个
     */
    public $FileName;

    /**
     * @var array 文件目录(正则)；长度不超过200个，内容base64转义
     */
    public $FileDirectory;

    /**
     * @var array 文件后缀；长度不超过200个，内容base64转义（废弃）
     */
    public $FileExtension;

    /**
     * @var array MD5列表
     */
    public $Md5List;

    /**
     * @param integer $Mode 白名单模式； 0MD5白名单，1自定义
     * @param integer $Id 规则唯一ID
     * @param array $QuuidList quuid 列表
     * @param integer $IsGlobal 是否全部主机； 0否，1是。
     * @param integer $MatchType 匹配模式 ；0 精确匹配，1模糊匹配(废弃)
     * @param array $FileName 文件名称(正则)；长度不超过200个
     * @param array $FileDirectory 文件目录(正则)；长度不超过200个，内容base64转义
     * @param array $FileExtension 文件后缀；长度不超过200个，内容base64转义（废弃）
     * @param array $Md5List MD5列表
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Mode",$param) and $param["Mode"] !== null) {
            $this->Mode = $param["Mode"];
        }

        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("QuuidList",$param) and $param["QuuidList"] !== null) {
            $this->QuuidList = $param["QuuidList"];
        }

        if (array_key_exists("IsGlobal",$param) and $param["IsGlobal"] !== null) {
            $this->IsGlobal = $param["IsGlobal"];
        }

        if (array_key_exists("MatchType",$param) and $param["MatchType"] !== null) {
            $this->MatchType = $param["MatchType"];
        }

        if (array_key_exists("FileName",$param) and $param["FileName"] !== null) {
            $this->FileName = $param["FileName"];
        }

        if (array_key_exists("FileDirectory",$param) and $param["FileDirectory"] !== null) {
            $this->FileDirectory = $param["FileDirectory"];
        }

        if (array_key_exists("FileExtension",$param) and $param["FileExtension"] !== null) {
            $this->FileExtension = $param["FileExtension"];
        }

        if (array_key_exists("Md5List",$param) and $param["Md5List"] !== null) {
            $this->Md5List = $param["Md5List"];
        }
    }
}
