<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 文件查杀概览信息
 *
 * @method integer getHostCount() 获取影响主机数
 * @method void setHostCount(integer $HostCount) 设置影响主机数
 * @method integer getProcessCount() 获取异常进程数
 * @method void setProcessCount(integer $ProcessCount) 设置异常进程数
 * @method integer getFileCount() 获取恶意文件数
 * @method void setFileCount(integer $FileCount) 设置恶意文件数
 * @method boolean getIsFirstScan() 获取是否首次扫描[false:否|true:是]
 * @method void setIsFirstScan(boolean $IsFirstScan) 设置是否首次扫描[false:否|true:是]
 * @method string getScanTime() 获取最后扫描时间
 * @method void setScanTime(string $ScanTime) 设置最后扫描时间
 */
class MalwareRiskOverview extends AbstractModel
{
    /**
     * @var integer 影响主机数
     */
    public $HostCount;

    /**
     * @var integer 异常进程数
     */
    public $ProcessCount;

    /**
     * @var integer 恶意文件数
     */
    public $FileCount;

    /**
     * @var boolean 是否首次扫描[false:否|true:是]
     */
    public $IsFirstScan;

    /**
     * @var string 最后扫描时间
     */
    public $ScanTime;

    /**
     * @param integer $HostCount 影响主机数
     * @param integer $ProcessCount 异常进程数
     * @param integer $FileCount 恶意文件数
     * @param boolean $IsFirstScan 是否首次扫描[false:否|true:是]
     * @param string $ScanTime 最后扫描时间
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("HostCount",$param) and $param["HostCount"] !== null) {
            $this->HostCount = $param["HostCount"];
        }

        if (array_key_exists("ProcessCount",$param) and $param["ProcessCount"] !== null) {
            $this->ProcessCount = $param["ProcessCount"];
        }

        if (array_key_exists("FileCount",$param) and $param["FileCount"] !== null) {
            $this->FileCount = $param["FileCount"];
        }

        if (array_key_exists("IsFirstScan",$param) and $param["IsFirstScan"] !== null) {
            $this->IsFirstScan = $param["IsFirstScan"];
        }

        if (array_key_exists("ScanTime",$param) and $param["ScanTime"] !== null) {
            $this->ScanTime = $param["ScanTime"];
        }
    }
}
