<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeMalwareTimingScanSetting返回参数结构体
 *
 * @method integer getCheckPattern() 获取检测模式 0 全盘检测  1快速检测
 * @method void setCheckPattern(integer $CheckPattern) 设置检测模式 0 全盘检测  1快速检测
 * @method string getStartTime() 获取检测周期 开始时间
 * @method void setStartTime(string $StartTime) 设置检测周期 开始时间
 * @method string getEndTime() 获取检测周期 超时结束时间
 * @method void setEndTime(string $EndTime) 设置检测周期 超时结束时间
 * @method integer getIsGlobal() 获取是否全部服务器 1 全部 2 自选
 * @method void setIsGlobal(integer $IsGlobal) 设置是否全部服务器 1 全部 2 自选
 * @method array getQuuidList() 获取自选服务器时必须 主机quuid的string数组
 * @method void setQuuidList(array $QuuidList) 设置自选服务器时必须 主机quuid的string数组
 * @method integer getMonitoringPattern() 获取监控模式 0 标准 1深度
 * @method void setMonitoringPattern(integer $MonitoringPattern) 设置监控模式 0 标准 1深度
 * @method integer getCycle() 获取周期 1每天
 * @method void setCycle(integer $Cycle) 设置周期 1每天
 * @method integer getEnableScan() 获取定时检测开关 0 关闭1 开启
 * @method void setEnableScan(integer $EnableScan) 设置定时检测开关 0 关闭1 开启
 * @method integer getId() 获取唯一ID
 * @method void setId(integer $Id) 设置唯一ID
 * @method integer getRealTimeMonitoring() 获取实时监控0 关闭 1开启
 * @method void setRealTimeMonitoring(integer $RealTimeMonitoring) 设置实时监控0 关闭 1开启
 * @method integer getAutoIsolation() 获取是否自动隔离：1-是，0-否
 * @method void setAutoIsolation(integer $AutoIsolation) 设置是否自动隔离：1-是，0-否
 * @method integer getClickTimeout() 获取一键扫描超时时长，如：1800秒（s）
 * @method void setClickTimeout(integer $ClickTimeout) 设置一键扫描超时时长，如：1800秒（s）
 * @method integer getKillProcess() 获取是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
 * @method void setKillProcess(integer $KillProcess) 设置是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
 * @method integer getEngineType() 获取1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
 * @method void setEngineType(integer $EngineType) 设置1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
 * @method integer getEnableInspiredEngine() 获取启发引擎 0 关闭 1开启
 * @method void setEnableInspiredEngine(integer $EnableInspiredEngine) 设置启发引擎 0 关闭 1开启
 * @method integer getEnableMemShellScan() 获取是否开启恶意进程查杀[0:未开启,1:开启]
 * @method void setEnableMemShellScan(integer $EnableMemShellScan) 设置是否开启恶意进程查杀[0:未开启,1:开启]
 * @method integer getProtectMode() 获取防护模式 0 标准 1 重保
 * @method void setProtectMode(integer $ProtectMode) 设置防护模式 0 标准 1 重保
 * @method integer getProtectFileScope() 获取查杀范围 0 脚本类之外的恶意文件，1全部恶意文件
 * @method void setProtectFileScope(integer $ProtectFileScope) 设置查杀范围 0 脚本类之外的恶意文件，1全部恶意文件
 * @method string getRequestId() 获取唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeMalwareTimingScanSettingResponse extends AbstractModel
{
    /**
     * @var integer 检测模式 0 全盘检测  1快速检测
     */
    public $CheckPattern;

    /**
     * @var string 检测周期 开始时间
     */
    public $StartTime;

    /**
     * @var string 检测周期 超时结束时间
     */
    public $EndTime;

    /**
     * @var integer 是否全部服务器 1 全部 2 自选
     */
    public $IsGlobal;

    /**
     * @var array 自选服务器时必须 主机quuid的string数组
     */
    public $QuuidList;

    /**
     * @var integer 监控模式 0 标准 1深度
     */
    public $MonitoringPattern;

    /**
     * @var integer 周期 1每天
     */
    public $Cycle;

    /**
     * @var integer 定时检测开关 0 关闭1 开启
     */
    public $EnableScan;

    /**
     * @var integer 唯一ID
     */
    public $Id;

    /**
     * @var integer 实时监控0 关闭 1开启
     */
    public $RealTimeMonitoring;

    /**
     * @var integer 是否自动隔离：1-是，0-否
     */
    public $AutoIsolation;

    /**
     * @var integer 一键扫描超时时长，如：1800秒（s）
     */
    public $ClickTimeout;

    /**
     * @var integer 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
     */
    public $KillProcess;

    /**
     * @var integer 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
     */
    public $EngineType;

    /**
     * @var integer 启发引擎 0 关闭 1开启
     */
    public $EnableInspiredEngine;

    /**
     * @var integer 是否开启恶意进程查杀[0:未开启,1:开启]
     */
    public $EnableMemShellScan;

    /**
     * @var integer 防护模式 0 标准 1 重保
     */
    public $ProtectMode;

    /**
     * @var integer 查杀范围 0 脚本类之外的恶意文件，1全部恶意文件
     */
    public $ProtectFileScope;

    /**
     * @var string 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $CheckPattern 检测模式 0 全盘检测  1快速检测
     * @param string $StartTime 检测周期 开始时间
     * @param string $EndTime 检测周期 超时结束时间
     * @param integer $IsGlobal 是否全部服务器 1 全部 2 自选
     * @param array $QuuidList 自选服务器时必须 主机quuid的string数组
     * @param integer $MonitoringPattern 监控模式 0 标准 1深度
     * @param integer $Cycle 周期 1每天
     * @param integer $EnableScan 定时检测开关 0 关闭1 开启
     * @param integer $Id 唯一ID
     * @param integer $RealTimeMonitoring 实时监控0 关闭 1开启
     * @param integer $AutoIsolation 是否自动隔离：1-是，0-否
     * @param integer $ClickTimeout 一键扫描超时时长，如：1800秒（s）
     * @param integer $KillProcess 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
     * @param integer $EngineType 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
     * @param integer $EnableInspiredEngine 启发引擎 0 关闭 1开启
     * @param integer $EnableMemShellScan 是否开启恶意进程查杀[0:未开启,1:开启]
     * @param integer $ProtectMode 防护模式 0 标准 1 重保
     * @param integer $ProtectFileScope 查杀范围 0 脚本类之外的恶意文件，1全部恶意文件
     * @param string $RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("CheckPattern",$param) and $param["CheckPattern"] !== null) {
            $this->CheckPattern = $param["CheckPattern"];
        }

        if (array_key_exists("StartTime",$param) and $param["StartTime"] !== null) {
            $this->StartTime = $param["StartTime"];
        }

        if (array_key_exists("EndTime",$param) and $param["EndTime"] !== null) {
            $this->EndTime = $param["EndTime"];
        }

        if (array_key_exists("IsGlobal",$param) and $param["IsGlobal"] !== null) {
            $this->IsGlobal = $param["IsGlobal"];
        }

        if (array_key_exists("QuuidList",$param) and $param["QuuidList"] !== null) {
            $this->QuuidList = $param["QuuidList"];
        }

        if (array_key_exists("MonitoringPattern",$param) and $param["MonitoringPattern"] !== null) {
            $this->MonitoringPattern = $param["MonitoringPattern"];
        }

        if (array_key_exists("Cycle",$param) and $param["Cycle"] !== null) {
            $this->Cycle = $param["Cycle"];
        }

        if (array_key_exists("EnableScan",$param) and $param["EnableScan"] !== null) {
            $this->EnableScan = $param["EnableScan"];
        }

        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("RealTimeMonitoring",$param) and $param["RealTimeMonitoring"] !== null) {
            $this->RealTimeMonitoring = $param["RealTimeMonitoring"];
        }

        if (array_key_exists("AutoIsolation",$param) and $param["AutoIsolation"] !== null) {
            $this->AutoIsolation = $param["AutoIsolation"];
        }

        if (array_key_exists("ClickTimeout",$param) and $param["ClickTimeout"] !== null) {
            $this->ClickTimeout = $param["ClickTimeout"];
        }

        if (array_key_exists("KillProcess",$param) and $param["KillProcess"] !== null) {
            $this->KillProcess = $param["KillProcess"];
        }

        if (array_key_exists("EngineType",$param) and $param["EngineType"] !== null) {
            $this->EngineType = $param["EngineType"];
        }

        if (array_key_exists("EnableInspiredEngine",$param) and $param["EnableInspiredEngine"] !== null) {
            $this->EnableInspiredEngine = $param["EnableInspiredEngine"];
        }

        if (array_key_exists("EnableMemShellScan",$param) and $param["EnableMemShellScan"] !== null) {
            $this->EnableMemShellScan = $param["EnableMemShellScan"];
        }

        if (array_key_exists("ProtectMode",$param) and $param["ProtectMode"] !== null) {
            $this->ProtectMode = $param["ProtectMode"];
        }

        if (array_key_exists("ProtectFileScope",$param) and $param["ProtectFileScope"] !== null) {
            $this->ProtectFileScope = $param["ProtectFileScope"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
