<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * CreateScanMalwareSetting请求参数结构体
 *
 * @method integer getScanPattern() 获取扫描模式 0 全盘扫描, 1 快速扫描
 * @method void setScanPattern(integer $ScanPattern) 设置扫描模式 0 全盘扫描, 1 快速扫描
 * @method integer getHostType() 获取服务器分类：1:专业版服务器；2:自选服务器
 * @method void setHostType(integer $HostType) 设置服务器分类：1:专业版服务器；2:自选服务器
 * @method array getQuuidList() 获取自选服务器时生效，主机quuid的string数组
 * @method void setQuuidList(array $QuuidList) 设置自选服务器时生效，主机quuid的string数组
 * @method integer getTimeoutPeriod() 获取超时时间单位 秒 默认3600 秒
 * @method void setTimeoutPeriod(integer $TimeoutPeriod) 设置超时时间单位 秒 默认3600 秒
 * @method integer getEngineType() 获取1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
 * @method void setEngineType(integer $EngineType) 设置1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
 * @method integer getEnableMemShellScan() 获取是否开启恶意进程查杀[0:未开启,1:开启]
 * @method void setEnableMemShellScan(integer $EnableMemShellScan) 设置是否开启恶意进程查杀[0:未开启,1:开启]
 */
class CreateScanMalwareSettingRequest extends AbstractModel
{
    /**
     * @var integer 扫描模式 0 全盘扫描, 1 快速扫描
     */
    public $ScanPattern;

    /**
     * @var integer 服务器分类：1:专业版服务器；2:自选服务器
     */
    public $HostType;

    /**
     * @var array 自选服务器时生效，主机quuid的string数组
     */
    public $QuuidList;

    /**
     * @var integer 超时时间单位 秒 默认3600 秒
     */
    public $TimeoutPeriod;

    /**
     * @var integer 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
     */
    public $EngineType;

    /**
     * @var integer 是否开启恶意进程查杀[0:未开启,1:开启]
     */
    public $EnableMemShellScan;

    /**
     * @param integer $ScanPattern 扫描模式 0 全盘扫描, 1 快速扫描
     * @param integer $HostType 服务器分类：1:专业版服务器；2:自选服务器
     * @param array $QuuidList 自选服务器时生效，主机quuid的string数组
     * @param integer $TimeoutPeriod 超时时间单位 秒 默认3600 秒
     * @param integer $EngineType 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
     * @param integer $EnableMemShellScan 是否开启恶意进程查杀[0:未开启,1:开启]
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ScanPattern",$param) and $param["ScanPattern"] !== null) {
            $this->ScanPattern = $param["ScanPattern"];
        }

        if (array_key_exists("HostType",$param) and $param["HostType"] !== null) {
            $this->HostType = $param["HostType"];
        }

        if (array_key_exists("QuuidList",$param) and $param["QuuidList"] !== null) {
            $this->QuuidList = $param["QuuidList"];
        }

        if (array_key_exists("TimeoutPeriod",$param) and $param["TimeoutPeriod"] !== null) {
            $this->TimeoutPeriod = $param["TimeoutPeriod"];
        }

        if (array_key_exists("EngineType",$param) and $param["EngineType"] !== null) {
            $this->EngineType = $param["EngineType"];
        }

        if (array_key_exists("EnableMemShellScan",$param) and $param["EnableMemShellScan"] !== null) {
            $this->EnableMemShellScan = $param["EnableMemShellScan"];
        }
    }
}
