<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cvm\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ModifyKeyPairAttribute请求参数结构体
 *
 * @method string getKeyId() 获取密钥对ID。可以通过以下方式获取可用的密钥 ID：
<li>通过登录[控制台](https://console.cloud.tencent.com/cvm/sshkey)查询密钥 ID。</li>
<li>通过调用接口 [DescribeKeyPairs](https://cloud.tencent.com/document/api/213/9403) ，取返回信息中的 `KeyId` 获取密钥对 ID。</li>
 * @method void setKeyId(string $KeyId) 设置密钥对ID。可以通过以下方式获取可用的密钥 ID：
<li>通过登录[控制台](https://console.cloud.tencent.com/cvm/sshkey)查询密钥 ID。</li>
<li>通过调用接口 [DescribeKeyPairs](https://cloud.tencent.com/document/api/213/9403) ，取返回信息中的 `KeyId` 获取密钥对 ID。</li>
 * @method string getKeyName() 获取修改后的密钥对名称，可由数字，字母和下划线组成，长度不超过25个字符。
 * @method void setKeyName(string $KeyName) 设置修改后的密钥对名称，可由数字，字母和下划线组成，长度不超过25个字符。
 * @method string getDescription() 获取修改后的密钥对描述信息。可任意命名，但不得超过60个字符。
 * @method void setDescription(string $Description) 设置修改后的密钥对描述信息。可任意命名，但不得超过60个字符。
 */
class ModifyKeyPairAttributeRequest extends AbstractModel
{
    /**
     * @var string 密钥对ID。可以通过以下方式获取可用的密钥 ID：
<li>通过登录[控制台](https://console.cloud.tencent.com/cvm/sshkey)查询密钥 ID。</li>
<li>通过调用接口 [DescribeKeyPairs](https://cloud.tencent.com/document/api/213/9403) ，取返回信息中的 `KeyId` 获取密钥对 ID。</li>
     */
    public $KeyId;

    /**
     * @var string 修改后的密钥对名称，可由数字，字母和下划线组成，长度不超过25个字符。
     */
    public $KeyName;

    /**
     * @var string 修改后的密钥对描述信息。可任意命名，但不得超过60个字符。
     */
    public $Description;

    /**
     * @param string $KeyId 密钥对ID。可以通过以下方式获取可用的密钥 ID：
<li>通过登录[控制台](https://console.cloud.tencent.com/cvm/sshkey)查询密钥 ID。</li>
<li>通过调用接口 [DescribeKeyPairs](https://cloud.tencent.com/document/api/213/9403) ，取返回信息中的 `KeyId` 获取密钥对 ID。</li>
     * @param string $KeyName 修改后的密钥对名称，可由数字，字母和下划线组成，长度不超过25个字符。
     * @param string $Description 修改后的密钥对描述信息。可任意命名，但不得超过60个字符。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("KeyId",$param) and $param["KeyId"] !== null) {
            $this->KeyId = $param["KeyId"];
        }

        if (array_key_exists("KeyName",$param) and $param["KeyName"] !== null) {
            $this->KeyName = $param["KeyName"];
        }

        if (array_key_exists("Description",$param) and $param["Description"] !== null) {
            $this->Description = $param["Description"];
        }
    }
}
