<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cvm\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ExportImages返回参数结构体
 *
 * @method integer getTaskId() 获取导出镜像任务ID
 * @method void setTaskId(integer $TaskId) 设置导出镜像任务ID
 * @method array getCosPaths() 获取导出镜像的COS文件名列表。其中，文件名格式如下。
* 系统盘：前缀名_镜像ID_system_快照ID.镜像格式
* 数据盘：前缀名_镜像ID_data_快照ID.镜像格式
 * @method void setCosPaths(array $CosPaths) 设置导出镜像的COS文件名列表。其中，文件名格式如下。
* 系统盘：前缀名_镜像ID_system_快照ID.镜像格式
* 数据盘：前缀名_镜像ID_data_快照ID.镜像格式
 * @method string getRequestId() 获取唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
 */
class ExportImagesResponse extends AbstractModel
{
    /**
     * @var integer 导出镜像任务ID
     */
    public $TaskId;

    /**
     * @var array 导出镜像的COS文件名列表。其中，文件名格式如下。
* 系统盘：前缀名_镜像ID_system_快照ID.镜像格式
* 数据盘：前缀名_镜像ID_data_快照ID.镜像格式
     */
    public $CosPaths;

    /**
     * @var string 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $TaskId 导出镜像任务ID
     * @param array $CosPaths 导出镜像的COS文件名列表。其中，文件名格式如下。
* 系统盘：前缀名_镜像ID_system_快照ID.镜像格式
* 数据盘：前缀名_镜像ID_data_快照ID.镜像格式
     * @param string $RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("TaskId",$param) and $param["TaskId"] !== null) {
            $this->TaskId = $param["TaskId"];
        }

        if (array_key_exists("CosPaths",$param) and $param["CosPaths"] !== null) {
            $this->CosPaths = $param["CosPaths"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
