<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ckafka\V20190819\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 路由实体对象
 *
 * @method integer getAccessType() 获取实例接入方式
0：PLAINTEXT (明文方式，没有带用户信息老版本及社区版本都支持)
1：SASL_PLAINTEXT（明文方式，不过在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
2：SSL（SSL加密通信，没有带用户信息，老版本及社区版本都支持）
3：SASL_SSL（SSL加密通信，在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
 * @method void setAccessType(integer $AccessType) 设置实例接入方式
0：PLAINTEXT (明文方式，没有带用户信息老版本及社区版本都支持)
1：SASL_PLAINTEXT（明文方式，不过在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
2：SSL（SSL加密通信，没有带用户信息，老版本及社区版本都支持）
3：SASL_SSL（SSL加密通信，在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
 * @method integer getRouteId() 获取路由Id
 * @method void setRouteId(integer $RouteId) 设置路由Id
 * @method integer getVipType() 获取vip网络类型（1:外网TGW  2:基础网络 3:VPC网络 4:支撑网络(idc 环境) 5:SSL外网访问方式访问 6:黑石环境vpc 7:支撑网络(cvm 环境）
 * @method void setVipType(integer $VipType) 设置vip网络类型（1:外网TGW  2:基础网络 3:VPC网络 4:支撑网络(idc 环境) 5:SSL外网访问方式访问 6:黑石环境vpc 7:支撑网络(cvm 环境）
 * @method array getVipList() 获取虚拟IP列表
 * @method void setVipList(array $VipList) 设置虚拟IP列表
 * @method string getDomain() 获取域名
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDomain(string $Domain) 设置域名
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getDomainPort() 获取域名port
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDomainPort(integer $DomainPort) 设置域名port
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getDeleteTimestamp() 获取时间戳
 * @method void setDeleteTimestamp(string $DeleteTimestamp) 设置时间戳
 * @method string getSubnet() 获取子网Id
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setSubnet(string $Subnet) 设置子网Id
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getBrokerVipList() 获取虚拟IP列表(1对1 broker节点)
 * @method void setBrokerVipList(array $BrokerVipList) 设置虚拟IP列表(1对1 broker节点)
 * @method string getVpcId() 获取私有网络Id
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setVpcId(string $VpcId) 设置私有网络Id
注意：此字段可能返回 null，表示取不到有效值。
 */
class Route extends AbstractModel
{
    /**
     * @var integer 实例接入方式
0：PLAINTEXT (明文方式，没有带用户信息老版本及社区版本都支持)
1：SASL_PLAINTEXT（明文方式，不过在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
2：SSL（SSL加密通信，没有带用户信息，老版本及社区版本都支持）
3：SASL_SSL（SSL加密通信，在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
     */
    public $AccessType;

    /**
     * @var integer 路由Id
     */
    public $RouteId;

    /**
     * @var integer vip网络类型（1:外网TGW  2:基础网络 3:VPC网络 4:支撑网络(idc 环境) 5:SSL外网访问方式访问 6:黑石环境vpc 7:支撑网络(cvm 环境）
     */
    public $VipType;

    /**
     * @var array 虚拟IP列表
     */
    public $VipList;

    /**
     * @var string 域名
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Domain;

    /**
     * @var integer 域名port
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DomainPort;

    /**
     * @var string 时间戳
     */
    public $DeleteTimestamp;

    /**
     * @var string 子网Id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Subnet;

    /**
     * @var array 虚拟IP列表(1对1 broker节点)
     */
    public $BrokerVipList;

    /**
     * @var string 私有网络Id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $VpcId;

    /**
     * @param integer $AccessType 实例接入方式
0：PLAINTEXT (明文方式，没有带用户信息老版本及社区版本都支持)
1：SASL_PLAINTEXT（明文方式，不过在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
2：SSL（SSL加密通信，没有带用户信息，老版本及社区版本都支持）
3：SASL_SSL（SSL加密通信，在数据开始时，会通过SASL方式登录鉴权，仅社区版本支持）
     * @param integer $RouteId 路由Id
     * @param integer $VipType vip网络类型（1:外网TGW  2:基础网络 3:VPC网络 4:支撑网络(idc 环境) 5:SSL外网访问方式访问 6:黑石环境vpc 7:支撑网络(cvm 环境）
     * @param array $VipList 虚拟IP列表
     * @param string $Domain 域名
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $DomainPort 域名port
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $DeleteTimestamp 时间戳
     * @param string $Subnet 子网Id
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $BrokerVipList 虚拟IP列表(1对1 broker节点)
     * @param string $VpcId 私有网络Id
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("AccessType",$param) and $param["AccessType"] !== null) {
            $this->AccessType = $param["AccessType"];
        }

        if (array_key_exists("RouteId",$param) and $param["RouteId"] !== null) {
            $this->RouteId = $param["RouteId"];
        }

        if (array_key_exists("VipType",$param) and $param["VipType"] !== null) {
            $this->VipType = $param["VipType"];
        }

        if (array_key_exists("VipList",$param) and $param["VipList"] !== null) {
            $this->VipList = [];
            foreach ($param["VipList"] as $key => $value){
                $obj = new VipEntity();
                $obj->deserialize($value);
                array_push($this->VipList, $obj);
            }
        }

        if (array_key_exists("Domain",$param) and $param["Domain"] !== null) {
            $this->Domain = $param["Domain"];
        }

        if (array_key_exists("DomainPort",$param) and $param["DomainPort"] !== null) {
            $this->DomainPort = $param["DomainPort"];
        }

        if (array_key_exists("DeleteTimestamp",$param) and $param["DeleteTimestamp"] !== null) {
            $this->DeleteTimestamp = $param["DeleteTimestamp"];
        }

        if (array_key_exists("Subnet",$param) and $param["Subnet"] !== null) {
            $this->Subnet = $param["Subnet"];
        }

        if (array_key_exists("BrokerVipList",$param) and $param["BrokerVipList"] !== null) {
            $this->BrokerVipList = [];
            foreach ($param["BrokerVipList"] as $key => $value){
                $obj = new VipEntity();
                $obj->deserialize($value);
                array_push($this->BrokerVipList, $obj);
            }
        }

        if (array_key_exists("VpcId",$param) and $param["VpcId"] !== null) {
            $this->VpcId = $param["VpcId"];
        }
    }
}
