<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Chdfs\V20190718\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ModifyLifeCycleRules请求参数结构体
 *
 * @method array getLifeCycleRules() 获取多个生命周期规则，上限为10
 * @method void setLifeCycleRules(array $LifeCycleRules) 设置多个生命周期规则，上限为10
 */
class ModifyLifeCycleRulesRequest extends AbstractModel
{
    /**
     * @var array 多个生命周期规则，上限为10
     */
    public $LifeCycleRules;

    /**
     * @param array $LifeCycleRules 多个生命周期规则，上限为10
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("LifeCycleRules",$param) and $param["LifeCycleRules"] !== null) {
            $this->LifeCycleRules = [];
            foreach ($param["LifeCycleRules"] as $key => $value){
                $obj = new LifeCycleRule();
                $obj->deserialize($value);
                array_push($this->LifeCycleRules, $obj);
            }
        }
    }
}
