<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cfw\V20190904\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeTLogIpList请求参数结构体
 *
 * @method string getEndTime() 获取结束时间
 * @method void setEndTime(string $EndTime) 设置结束时间
 * @method string getQueryType() 获取类型 1 告警 2阻断
 * @method void setQueryType(string $QueryType) 设置类型 1 告警 2阻断
 * @method string getStartTime() 获取开始时间
 * @method void setStartTime(string $StartTime) 设置开始时间
 * @method integer getTop() 获取top数
 * @method void setTop(integer $Top) 设置top数
 * @method string getSearchValue() 获取查询条件
 * @method void setSearchValue(string $SearchValue) 设置查询条件
 */
class DescribeTLogIpListRequest extends AbstractModel
{
    /**
     * @var string 结束时间
     */
    public $EndTime;

    /**
     * @var string 类型 1 告警 2阻断
     */
    public $QueryType;

    /**
     * @var string 开始时间
     */
    public $StartTime;

    /**
     * @var integer top数
     */
    public $Top;

    /**
     * @var string 查询条件
     */
    public $SearchValue;

    /**
     * @param string $EndTime 结束时间
     * @param string $QueryType 类型 1 告警 2阻断
     * @param string $StartTime 开始时间
     * @param integer $Top top数
     * @param string $SearchValue 查询条件
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("EndTime",$param) and $param["EndTime"] !== null) {
            $this->EndTime = $param["EndTime"];
        }

        if (array_key_exists("QueryType",$param) and $param["QueryType"] !== null) {
            $this->QueryType = $param["QueryType"];
        }

        if (array_key_exists("StartTime",$param) and $param["StartTime"] !== null) {
            $this->StartTime = $param["StartTime"];
        }

        if (array_key_exists("Top",$param) and $param["Top"] !== null) {
            $this->Top = $param["Top"];
        }

        if (array_key_exists("SearchValue",$param) and $param["SearchValue"] !== null) {
            $this->SearchValue = $param["SearchValue"];
        }
    }
}
