<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 描述漏洞的详细信息。
 *
 * @method VulnerabilitySummary getSummary() 获取漏洞概览信息
 * @method void setSummary(VulnerabilitySummary $Summary) 设置漏洞概览信息
 * @method VulnerabilityDetail getDetail() 获取漏洞详细信息
 * @method void setDetail(VulnerabilityDetail $Detail) 设置漏洞详细信息
 */
class VulnerabilityUnion extends AbstractModel
{
    /**
     * @var VulnerabilitySummary 漏洞概览信息
     */
    public $Summary;

    /**
     * @var VulnerabilityDetail 漏洞详细信息
     */
    public $Detail;

    /**
     * @param VulnerabilitySummary $Summary 漏洞概览信息
     * @param VulnerabilityDetail $Detail 漏洞详细信息
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Summary",$param) and $param["Summary"] !== null) {
            $this->Summary = new VulnerabilitySummary();
            $this->Summary->deserialize($param["Summary"]);
        }

        if (array_key_exists("Detail",$param) and $param["Detail"] !== null) {
            $this->Detail = new VulnerabilityDetail();
            $this->Detail->deserialize($param["Detail"]);
        }
    }
}
