<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 描述漏洞详细信息。
 *
 * @method string getCategory() 获取漏洞类别
 * @method void setCategory(string $Category) 设置漏洞类别
 * @method string getCategoryType() 获取漏洞分类
 * @method void setCategoryType(string $CategoryType) 设置漏洞分类
 * @method string getDescription() 获取漏洞描述
 * @method void setDescription(string $Description) 设置漏洞描述
 * @method string getOfficialSolution() 获取漏洞官方解决方案
 * @method void setOfficialSolution(string $OfficialSolution) 设置漏洞官方解决方案
 * @method array getReferenceList() 获取漏洞信息参考列表
 * @method void setReferenceList(array $ReferenceList) 设置漏洞信息参考列表
 * @method string getDefenseSolution() 获取漏洞防御方案
 * @method void setDefenseSolution(string $DefenseSolution) 设置漏洞防御方案
 * @method CVSSV2Info getCVSSv2Info() 获取漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCVSSv2Info(CVSSV2Info $CVSSv2Info) 设置漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method CVSSV3Info getCVSSv3Info() 获取漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCVSSv3Info(CVSSV3Info $CVSSv3Info) 设置漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getSubmitTime() 获取漏洞提交时间
 * @method void setSubmitTime(string $SubmitTime) 设置漏洞提交时间
 * @method string getUpdateTime() 获取漏洞更新时间
 * @method void setUpdateTime(string $UpdateTime) 设置漏洞更新时间
 * @method string getCWEID() 获取CWE编号
 * @method void setCWEID(string $CWEID) 设置CWE编号
 * @method string getCVSSv2Vector() 获取漏洞CVSSv2向量
 * @method void setCVSSv2Vector(string $CVSSv2Vector) 设置漏洞CVSSv2向量
 * @method string getCVSSv3Vector() 获取漏洞CVSSv3向量
 * @method void setCVSSv3Vector(string $CVSSv3Vector) 设置漏洞CVSSv3向量
 * @method array getAffectedComponentList() 获取漏洞影响的组件列表，仅当查询单个漏洞时有效
 * @method void setAffectedComponentList(array $AffectedComponentList) 设置漏洞影响的组件列表，仅当查询单个漏洞时有效
 */
class VulnerabilityDetail extends AbstractModel
{
    /**
     * @var string 漏洞类别
     */
    public $Category;

    /**
     * @var string 漏洞分类
     */
    public $CategoryType;

    /**
     * @var string 漏洞描述
     */
    public $Description;

    /**
     * @var string 漏洞官方解决方案
     */
    public $OfficialSolution;

    /**
     * @var array 漏洞信息参考列表
     */
    public $ReferenceList;

    /**
     * @var string 漏洞防御方案
     */
    public $DefenseSolution;

    /**
     * @var CVSSV2Info 漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $CVSSv2Info;

    /**
     * @var CVSSV3Info 漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $CVSSv3Info;

    /**
     * @var string 漏洞提交时间
     */
    public $SubmitTime;

    /**
     * @var string 漏洞更新时间
     */
    public $UpdateTime;

    /**
     * @var string CWE编号
     */
    public $CWEID;

    /**
     * @var string 漏洞CVSSv2向量
     */
    public $CVSSv2Vector;

    /**
     * @var string 漏洞CVSSv3向量
     */
    public $CVSSv3Vector;

    /**
     * @var array 漏洞影响的组件列表，仅当查询单个漏洞时有效
     */
    public $AffectedComponentList;

    /**
     * @param string $Category 漏洞类别
     * @param string $CategoryType 漏洞分类
     * @param string $Description 漏洞描述
     * @param string $OfficialSolution 漏洞官方解决方案
     * @param array $ReferenceList 漏洞信息参考列表
     * @param string $DefenseSolution 漏洞防御方案
     * @param CVSSV2Info $CVSSv2Info 漏洞CVSSv2信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param CVSSV3Info $CVSSv3Info 漏洞CVSSv3信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $SubmitTime 漏洞提交时间
     * @param string $UpdateTime 漏洞更新时间
     * @param string $CWEID CWE编号
     * @param string $CVSSv2Vector 漏洞CVSSv2向量
     * @param string $CVSSv3Vector 漏洞CVSSv3向量
     * @param array $AffectedComponentList 漏洞影响的组件列表，仅当查询单个漏洞时有效
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Category",$param) and $param["Category"] !== null) {
            $this->Category = $param["Category"];
        }

        if (array_key_exists("CategoryType",$param) and $param["CategoryType"] !== null) {
            $this->CategoryType = $param["CategoryType"];
        }

        if (array_key_exists("Description",$param) and $param["Description"] !== null) {
            $this->Description = $param["Description"];
        }

        if (array_key_exists("OfficialSolution",$param) and $param["OfficialSolution"] !== null) {
            $this->OfficialSolution = $param["OfficialSolution"];
        }

        if (array_key_exists("ReferenceList",$param) and $param["ReferenceList"] !== null) {
            $this->ReferenceList = $param["ReferenceList"];
        }

        if (array_key_exists("DefenseSolution",$param) and $param["DefenseSolution"] !== null) {
            $this->DefenseSolution = $param["DefenseSolution"];
        }

        if (array_key_exists("CVSSv2Info",$param) and $param["CVSSv2Info"] !== null) {
            $this->CVSSv2Info = new CVSSV2Info();
            $this->CVSSv2Info->deserialize($param["CVSSv2Info"]);
        }

        if (array_key_exists("CVSSv3Info",$param) and $param["CVSSv3Info"] !== null) {
            $this->CVSSv3Info = new CVSSV3Info();
            $this->CVSSv3Info->deserialize($param["CVSSv3Info"]);
        }

        if (array_key_exists("SubmitTime",$param) and $param["SubmitTime"] !== null) {
            $this->SubmitTime = $param["SubmitTime"];
        }

        if (array_key_exists("UpdateTime",$param) and $param["UpdateTime"] !== null) {
            $this->UpdateTime = $param["UpdateTime"];
        }

        if (array_key_exists("CWEID",$param) and $param["CWEID"] !== null) {
            $this->CWEID = $param["CWEID"];
        }

        if (array_key_exists("CVSSv2Vector",$param) and $param["CVSSv2Vector"] !== null) {
            $this->CVSSv2Vector = $param["CVSSv2Vector"];
        }

        if (array_key_exists("CVSSv3Vector",$param) and $param["CVSSv3Vector"] !== null) {
            $this->CVSSv3Vector = $param["CVSSv3Vector"];
        }

        if (array_key_exists("AffectedComponentList",$param) and $param["AffectedComponentList"] !== null) {
            $this->AffectedComponentList = [];
            foreach ($param["AffectedComponentList"] as $key => $value){
                $obj = new AffectedComponent();
                $obj->deserialize($value);
                array_push($this->AffectedComponentList, $obj);
            }
        }
    }
}
