<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeKBComponentVulnerability请求参数结构体
 *
 * @method PURL getPURL() 获取组件的PURL，其中Name和Version为必填字段
 * @method void setPURL(PURL $PURL) 设置组件的PURL，其中Name和Version为必填字段
 * @method string getLanguage() 获取语言，ZH或EN
 * @method void setLanguage(string $Language) 设置语言，ZH或EN
 */
class DescribeKBComponentVulnerabilityRequest extends AbstractModel
{
    /**
     * @var PURL 组件的PURL，其中Name和Version为必填字段
     */
    public $PURL;

    /**
     * @var string 语言，ZH或EN
     */
    public $Language;

    /**
     * @param PURL $PURL 组件的PURL，其中Name和Version为必填字段
     * @param string $Language 语言，ZH或EN
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("PURL",$param) and $param["PURL"] !== null) {
            $this->PURL = new PURL();
            $this->PURL->deserialize($param["PURL"]);
        }

        if (array_key_exists("Language",$param) and $param["Language"] !== null) {
            $this->Language = $param["Language"];
        }
    }
}
