<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Batch\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 描述了单项的价格信息
 *
 * @method float getUnitPrice() 获取后续合计费用的原价，后付费模式使用，单位：元。<br><li>如返回了其他时间区间项，如UnitPriceSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
 * @method void setUnitPrice(float $UnitPrice) 设置后续合计费用的原价，后付费模式使用，单位：元。<br><li>如返回了其他时间区间项，如UnitPriceSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
 * @method string getChargeUnit() 获取后续计价单元，后付费模式使用，可取值范围： <br><li>HOUR：表示计价单元是按每小时来计算。当前涉及该计价单元的场景有：实例按小时后付费（POSTPAID_BY_HOUR）、带宽按小时后付费（BANDWIDTH_POSTPAID_BY_HOUR）：</li><li>GB：表示计价单元是按每GB来计算。当前涉及该计价单元的场景有：流量按小时后付费（TRAFFIC_POSTPAID_BY_HOUR）。</li>
 * @method void setChargeUnit(string $ChargeUnit) 设置后续计价单元，后付费模式使用，可取值范围： <br><li>HOUR：表示计价单元是按每小时来计算。当前涉及该计价单元的场景有：实例按小时后付费（POSTPAID_BY_HOUR）、带宽按小时后付费（BANDWIDTH_POSTPAID_BY_HOUR）：</li><li>GB：表示计价单元是按每GB来计算。当前涉及该计价单元的场景有：流量按小时后付费（TRAFFIC_POSTPAID_BY_HOUR）。</li>
 * @method float getOriginalPrice() 获取预支合计费用的原价，预付费模式使用，单位：元。
 * @method void setOriginalPrice(float $OriginalPrice) 设置预支合计费用的原价，预付费模式使用，单位：元。
 * @method float getDiscountPrice() 获取预支合计费用的折扣价，预付费模式使用，单位：元。
 * @method void setDiscountPrice(float $DiscountPrice) 设置预支合计费用的折扣价，预付费模式使用，单位：元。
 * @method float getDiscount() 获取折扣，如20.0代表2折。
 * @method void setDiscount(float $Discount) 设置折扣，如20.0代表2折。
 * @method float getUnitPriceDiscount() 获取后续合计费用的折扣价，后付费模式使用，单位：元<br><li>如返回了其他时间区间项，如UnitPriceDiscountSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
 * @method void setUnitPriceDiscount(float $UnitPriceDiscount) 设置后续合计费用的折扣价，后付费模式使用，单位：元<br><li>如返回了其他时间区间项，如UnitPriceDiscountSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
 * @method float getUnitPriceSecondStep() 获取使用时间区间在(96, 360)小时的后续合计费用的原价，后付费模式使用，单位：元。
 * @method void setUnitPriceSecondStep(float $UnitPriceSecondStep) 设置使用时间区间在(96, 360)小时的后续合计费用的原价，后付费模式使用，单位：元。
 * @method float getUnitPriceDiscountSecondStep() 获取使用时间区间在(96, 360)小时的后续合计费用的折扣价，后付费模式使用，单位：元
 * @method void setUnitPriceDiscountSecondStep(float $UnitPriceDiscountSecondStep) 设置使用时间区间在(96, 360)小时的后续合计费用的折扣价，后付费模式使用，单位：元
 * @method float getUnitPriceThirdStep() 获取使用时间区间在(360, ∞)小时的后续合计费用的原价，后付费模式使用，单位：元。
 * @method void setUnitPriceThirdStep(float $UnitPriceThirdStep) 设置使用时间区间在(360, ∞)小时的后续合计费用的原价，后付费模式使用，单位：元。
 * @method float getUnitPriceDiscountThirdStep() 获取使用时间区间在(360, ∞)小时的后续合计费用的折扣价，后付费模式使用，单位：元
 * @method void setUnitPriceDiscountThirdStep(float $UnitPriceDiscountThirdStep) 设置使用时间区间在(360, ∞)小时的后续合计费用的折扣价，后付费模式使用，单位：元
 * @method float getOriginalPriceThreeYear() 获取预支三年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setOriginalPriceThreeYear(float $OriginalPriceThreeYear) 设置预支三年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getDiscountPriceThreeYear() 获取预支三年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDiscountPriceThreeYear(float $DiscountPriceThreeYear) 设置预支三年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getDiscountThreeYear() 获取预支三年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDiscountThreeYear(float $DiscountThreeYear) 设置预支三年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getOriginalPriceFiveYear() 获取预支五年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setOriginalPriceFiveYear(float $OriginalPriceFiveYear) 设置预支五年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getDiscountPriceFiveYear() 获取预支五年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDiscountPriceFiveYear(float $DiscountPriceFiveYear) 设置预支五年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getDiscountFiveYear() 获取预支五年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDiscountFiveYear(float $DiscountFiveYear) 设置预支五年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getOriginalPriceOneYear() 获取预支一年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setOriginalPriceOneYear(float $OriginalPriceOneYear) 设置预支一年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getDiscountPriceOneYear() 获取预支一年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDiscountPriceOneYear(float $DiscountPriceOneYear) 设置预支一年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
 * @method float getDiscountOneYear() 获取预支一年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDiscountOneYear(float $DiscountOneYear) 设置预支一年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
 */
class ItemPrice extends AbstractModel
{
    /**
     * @var float 后续合计费用的原价，后付费模式使用，单位：元。<br><li>如返回了其他时间区间项，如UnitPriceSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
     */
    public $UnitPrice;

    /**
     * @var string 后续计价单元，后付费模式使用，可取值范围： <br><li>HOUR：表示计价单元是按每小时来计算。当前涉及该计价单元的场景有：实例按小时后付费（POSTPAID_BY_HOUR）、带宽按小时后付费（BANDWIDTH_POSTPAID_BY_HOUR）：</li><li>GB：表示计价单元是按每GB来计算。当前涉及该计价单元的场景有：流量按小时后付费（TRAFFIC_POSTPAID_BY_HOUR）。</li>
     */
    public $ChargeUnit;

    /**
     * @var float 预支合计费用的原价，预付费模式使用，单位：元。
     */
    public $OriginalPrice;

    /**
     * @var float 预支合计费用的折扣价，预付费模式使用，单位：元。
     */
    public $DiscountPrice;

    /**
     * @var float 折扣，如20.0代表2折。
     */
    public $Discount;

    /**
     * @var float 后续合计费用的折扣价，后付费模式使用，单位：元<br><li>如返回了其他时间区间项，如UnitPriceDiscountSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
     */
    public $UnitPriceDiscount;

    /**
     * @var float 使用时间区间在(96, 360)小时的后续合计费用的原价，后付费模式使用，单位：元。
     */
    public $UnitPriceSecondStep;

    /**
     * @var float 使用时间区间在(96, 360)小时的后续合计费用的折扣价，后付费模式使用，单位：元
     */
    public $UnitPriceDiscountSecondStep;

    /**
     * @var float 使用时间区间在(360, ∞)小时的后续合计费用的原价，后付费模式使用，单位：元。
     */
    public $UnitPriceThirdStep;

    /**
     * @var float 使用时间区间在(360, ∞)小时的后续合计费用的折扣价，后付费模式使用，单位：元
     */
    public $UnitPriceDiscountThirdStep;

    /**
     * @var float 预支三年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $OriginalPriceThreeYear;

    /**
     * @var float 预支三年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DiscountPriceThreeYear;

    /**
     * @var float 预支三年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DiscountThreeYear;

    /**
     * @var float 预支五年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $OriginalPriceFiveYear;

    /**
     * @var float 预支五年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DiscountPriceFiveYear;

    /**
     * @var float 预支五年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DiscountFiveYear;

    /**
     * @var float 预支一年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $OriginalPriceOneYear;

    /**
     * @var float 预支一年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DiscountPriceOneYear;

    /**
     * @var float 预支一年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DiscountOneYear;

    /**
     * @param float $UnitPrice 后续合计费用的原价，后付费模式使用，单位：元。<br><li>如返回了其他时间区间项，如UnitPriceSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
     * @param string $ChargeUnit 后续计价单元，后付费模式使用，可取值范围： <br><li>HOUR：表示计价单元是按每小时来计算。当前涉及该计价单元的场景有：实例按小时后付费（POSTPAID_BY_HOUR）、带宽按小时后付费（BANDWIDTH_POSTPAID_BY_HOUR）：</li><li>GB：表示计价单元是按每GB来计算。当前涉及该计价单元的场景有：流量按小时后付费（TRAFFIC_POSTPAID_BY_HOUR）。</li>
     * @param float $OriginalPrice 预支合计费用的原价，预付费模式使用，单位：元。
     * @param float $DiscountPrice 预支合计费用的折扣价，预付费模式使用，单位：元。
     * @param float $Discount 折扣，如20.0代表2折。
     * @param float $UnitPriceDiscount 后续合计费用的折扣价，后付费模式使用，单位：元<br><li>如返回了其他时间区间项，如UnitPriceDiscountSecondStep，则本项代表时间区间在(0, 96)小时；若未返回其他时间区间项，则本项代表全时段，即(0, ∞)小时</li>
     * @param float $UnitPriceSecondStep 使用时间区间在(96, 360)小时的后续合计费用的原价，后付费模式使用，单位：元。
     * @param float $UnitPriceDiscountSecondStep 使用时间区间在(96, 360)小时的后续合计费用的折扣价，后付费模式使用，单位：元
     * @param float $UnitPriceThirdStep 使用时间区间在(360, ∞)小时的后续合计费用的原价，后付费模式使用，单位：元。
     * @param float $UnitPriceDiscountThirdStep 使用时间区间在(360, ∞)小时的后续合计费用的折扣价，后付费模式使用，单位：元
     * @param float $OriginalPriceThreeYear 预支三年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $DiscountPriceThreeYear 预支三年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $DiscountThreeYear 预支三年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $OriginalPriceFiveYear 预支五年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $DiscountPriceFiveYear 预支五年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $DiscountFiveYear 预支五年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $OriginalPriceOneYear 预支一年合计费用的原价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $DiscountPriceOneYear 预支一年合计费用的折扣价，预付费模式使用，单位：元。
注意：此字段可能返回 null，表示取不到有效值。
     * @param float $DiscountOneYear 预支一年应用的折扣，如20.0代表2折。
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("UnitPrice",$param) and $param["UnitPrice"] !== null) {
            $this->UnitPrice = $param["UnitPrice"];
        }

        if (array_key_exists("ChargeUnit",$param) and $param["ChargeUnit"] !== null) {
            $this->ChargeUnit = $param["ChargeUnit"];
        }

        if (array_key_exists("OriginalPrice",$param) and $param["OriginalPrice"] !== null) {
            $this->OriginalPrice = $param["OriginalPrice"];
        }

        if (array_key_exists("DiscountPrice",$param) and $param["DiscountPrice"] !== null) {
            $this->DiscountPrice = $param["DiscountPrice"];
        }

        if (array_key_exists("Discount",$param) and $param["Discount"] !== null) {
            $this->Discount = $param["Discount"];
        }

        if (array_key_exists("UnitPriceDiscount",$param) and $param["UnitPriceDiscount"] !== null) {
            $this->UnitPriceDiscount = $param["UnitPriceDiscount"];
        }

        if (array_key_exists("UnitPriceSecondStep",$param) and $param["UnitPriceSecondStep"] !== null) {
            $this->UnitPriceSecondStep = $param["UnitPriceSecondStep"];
        }

        if (array_key_exists("UnitPriceDiscountSecondStep",$param) and $param["UnitPriceDiscountSecondStep"] !== null) {
            $this->UnitPriceDiscountSecondStep = $param["UnitPriceDiscountSecondStep"];
        }

        if (array_key_exists("UnitPriceThirdStep",$param) and $param["UnitPriceThirdStep"] !== null) {
            $this->UnitPriceThirdStep = $param["UnitPriceThirdStep"];
        }

        if (array_key_exists("UnitPriceDiscountThirdStep",$param) and $param["UnitPriceDiscountThirdStep"] !== null) {
            $this->UnitPriceDiscountThirdStep = $param["UnitPriceDiscountThirdStep"];
        }

        if (array_key_exists("OriginalPriceThreeYear",$param) and $param["OriginalPriceThreeYear"] !== null) {
            $this->OriginalPriceThreeYear = $param["OriginalPriceThreeYear"];
        }

        if (array_key_exists("DiscountPriceThreeYear",$param) and $param["DiscountPriceThreeYear"] !== null) {
            $this->DiscountPriceThreeYear = $param["DiscountPriceThreeYear"];
        }

        if (array_key_exists("DiscountThreeYear",$param) and $param["DiscountThreeYear"] !== null) {
            $this->DiscountThreeYear = $param["DiscountThreeYear"];
        }

        if (array_key_exists("OriginalPriceFiveYear",$param) and $param["OriginalPriceFiveYear"] !== null) {
            $this->OriginalPriceFiveYear = $param["OriginalPriceFiveYear"];
        }

        if (array_key_exists("DiscountPriceFiveYear",$param) and $param["DiscountPriceFiveYear"] !== null) {
            $this->DiscountPriceFiveYear = $param["DiscountPriceFiveYear"];
        }

        if (array_key_exists("DiscountFiveYear",$param) and $param["DiscountFiveYear"] !== null) {
            $this->DiscountFiveYear = $param["DiscountFiveYear"];
        }

        if (array_key_exists("OriginalPriceOneYear",$param) and $param["OriginalPriceOneYear"] !== null) {
            $this->OriginalPriceOneYear = $param["OriginalPriceOneYear"];
        }

        if (array_key_exists("DiscountPriceOneYear",$param) and $param["DiscountPriceOneYear"] !== null) {
            $this->DiscountPriceOneYear = $param["DiscountPriceOneYear"];
        }

        if (array_key_exists("DiscountOneYear",$param) and $param["DiscountOneYear"] !== null) {
            $this->DiscountOneYear = $param["DiscountOneYear"];
        }
    }
}
