<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Apm\V20210622\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 指标列表单元
 *
 * @method array getFields() 获取field数组，用于指标的查询结果
 * @method void setFields(array $Fields) 设置field数组，用于指标的查询结果
 * @method array getTags() 获取tag数组，用于区分 Groupby 的对象
 * @method void setTags(array $Tags) 设置tag数组，用于区分 Groupby 的对象
 */
class ApmMetricRecord extends AbstractModel
{
    /**
     * @var array field数组，用于指标的查询结果
     */
    public $Fields;

    /**
     * @var array tag数组，用于区分 Groupby 的对象
     */
    public $Tags;

    /**
     * @param array $Fields field数组，用于指标的查询结果
     * @param array $Tags tag数组，用于区分 Groupby 的对象
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Fields",$param) and $param["Fields"] !== null) {
            $this->Fields = [];
            foreach ($param["Fields"] as $key => $value){
                $obj = new ApmField();
                $obj->deserialize($value);
                array_push($this->Fields, $obj);
            }
        }

        if (array_key_exists("Tags",$param) and $param["Tags"] !== null) {
            $this->Tags = [];
            foreach ($param["Tags"] as $key => $value){
                $obj = new ApmTag();
                $obj->deserialize($value);
                array_push($this->Tags, $obj);
            }
        }
    }
}
