<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace TencentCloud\Afc\V20200226;

use TencentCloud\Common\AbstractClient;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Credential;
use TencentCloud\Afc\V20200226\Models as Models;

/**
 * @method Models\GetAntiFraudVipResponse GetAntiFraudVip(Models\GetAntiFraudVipRequest $req) 反欺诈VIP评分接口
 * @method Models\QueryAntiFraudVipResponse QueryAntiFraudVip(Models\QueryAntiFraudVipRequest $req) 天御反欺诈服务，主要应用于银行、证券、保险、P2P等金融行业客户，通过腾讯的大数据风控能力，
可以准确识别恶意用户信息，解决客户在支付、活动、理财，风控等业务环节遇到的欺诈威胁，降低企业
的损失。
 * @method Models\TransportGeneralInterfaceResponse TransportGeneralInterface(Models\TransportGeneralInterfaceRequest $req) 天御信鸽取数平台接口
 */

class AfcClient extends AbstractClient
{
    /**
     * @var string
     */
    protected $endpoint = "afc.tencentcloudapi.com";

    /**
     * @var string
     */
    protected $service = "afc";

    /**
     * @var string
     */
    protected $version = "2020-02-26";

    /**
     * @param Credential $credential
     * @param string $region
     * @param ClientProfile|null $profile
     * @throws TencentCloudSDKException
     */
    function __construct($credential, $region, $profile=null)
    {
        parent::__construct($this->endpoint, $this->version, $credential, $region, $profile);
    }

    public function returnResponse($action, $response)
    {
        $respClass = "TencentCloud"."\\".ucfirst("afc")."\\"."V20200226\\Models"."\\".ucfirst($action)."Response";
        $obj = new $respClass();
        $obj->deserialize($response);
        return $obj;
    }
}
