<?php /*a:1:{s:56:"C:\wamp64\www\zbg\app\admin\view\help\article\index.html";i:1748488580;}*/ ?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">
            <form class="layui-form" lay-filter="article-form-search">
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <div class="layui-btn-group">
                            <a class="layui-btn" id="top-article-add"><i class="layui-icon layui-icon-add-circle"></i> 添加</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="layui-card-body">
            <table lay-filter="article" id="article"></table>
        </div>
    </div>
</div>
<!--JS部分-->
<script type="text/javascript">
    let CATE_LISTS = <?php echo $cate_lists; ?>;
    layui.use(['xmSelect', 'buildItems'],function(){
        var map_root = layui.cache.maps;
        var app_root = map_root + 'help.article/';
        var table=layui.table,form=layui.form,layer = layui.layer,admin = layui.admin;
        const cateListsValue = $.map(CATE_LISTS, function(cate) {
            return { key: cate.id, value: cate.name };
        }).reduce((acc, item) => {
            acc[item.key] = item.value;
            return acc;
        }, {});
        var type_select = '<option value="">选择分类</option>'; $.each(CATE_LISTS,function(k,v){type_select += '<option value="'+ v.id +'">'+ v.name +'</option>';});
        $('#search_type_select').html(type_select);

        //渲染搜索元素
        form.render(null, 'article-form-search');
        /*渲染数据*/
        table.render({
            elem: '#article',
            url: app_root+"index?do=json",
            cols: [[
                {field:"id",title:"ID",width:80},
                {field:"title",title:"文章标题"},
                {field:"sort",title:"排序"},
                {field:"cate_id",title:"分类",templet:function(d){return cateListsValue[d.cate_id]}},
                {field:'status',width:100,align:'center',templet:function(d){return '<input type="checkbox" name="status" disabled lay-skin="switch" lay-text="启用|禁用" value="'+d.status+'" data-json="'+encodeURIComponent(JSON.stringify(d))+'"'+(d.status==1 ? ' checked' : '')+'>';}, title:'启用状态'},
                {field:'class',width:100,align:'center', title:'小图标'},
                {field:'created_at',width:180,align:'center',title:'发布时间'},
                {fixed:'right',title:'操作',width:150,align:'center',toolbar:'<div><a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a></div>'}
            ]],
            page: true,
            limit:<?php echo htmlentities((string) $limit); ?>
        });/**/
        /*监听搜索*/
        form.on('submit(top-article-search)', function(data){
            table.reloadData('article',{where:data.field,page:{curr:1}});
            return false;
        });/**/
        /*监听全部按钮*/
        form.on('submit(top-article-all)', function(){
            table.reloadData('article',{where:'',page:{curr:1}});
            return false;
        });/**/

        /*顶部添加按钮*/
        $('#top-article-add').on('click',function(){articleOpen();});

        /*工具条监听*/
        table.on('tool(article)', function(obj) {
            var data = obj.data;
            var id = data.id;
            if (obj.event === 'edit') {
                articleOpen(data);
            }
        });
        /*添加、编辑弹出窗*/
        function articleOpen(Dt){
            admin.open({
                type: 1,
                bid: 'article_items',
                btn: ['保存', '取消'],
                area: ['100%', '100%'],
                title: (Dt ? '编辑' : '添加') + ' 文章',
                success: function(l,index){
                    layui.buildItems.build({
                        bid: 'article_items',
                        gid: 'article_items',
                        data: [
                            {name:"id",type:"hidden"},
                            {name:"title",title:"文章标题",type:"text",must:true,verify:'required'},
                            {name:"cate_id",title:"文章分类",type:"html",html:'<div id="help-cate-list-tree" class="v-xmselect-tree"></div>', must:true,verify:'required'},
                            {name:"sort",title:"排序",type:"number",value:'100',verify:'required',placeholder:"请输入排序，数字越大越靠前"},
                            {name:"status",title:"状态",type:"switch",value:'1'},
                            {name:"class",title:"小图标",type:"text"},
                            {name:"content",title:"内容",type:"ueditor",placeholder:"请输入描述简介"},
                        ]
                    });
                    console.log(Dt)
                    form.val('article_items_form',Dt);

                    layui.xmSelect.render({
                        el: '#help-cate-list-tree',
                        name: 'cate_id',
                        tips: '文章分类',
                        height: '75px',
                        data: CATE_LISTS,
                        filterable: true,
                        radio: true,
                        clickClose: true,
                        layVerify: 'required',
                        layVerType: 'tips',
                        layReqText: '请选择文章分类',
                        model: {label:{type:'text'}},
                        initValue: [Dt ? Dt.cate_id : 0],
                        prop: {name:'name',value:'id',disabled:'disabled'},
                        tree: {show:true,indent:25,strict:false,expandedKeys:true}
                    });
                    form.on('submit(article_items)',function(data){
                        var btn = $(this);
                        if (btn.attr('stop')){return false}else{btn.attr('stop',1)}
                        var field = data.field;
                        var post_url = field.id ? app_root+'edit' : app_root+'add';
                        field.status  = field.hasOwnProperty('status') ? field.status : '0';
                        admin.req(post_url,field,function(res){
                            layer.msg(res.msg,{shade:[0.4,'#000'],time:1500},function(){
                                if(res.code==1){
                                    layer.close(index);
                                    table.reloadData('article');
                                }
                                btn.removeAttr('stop');
                            });
                        },'post',{headersToken:true});
                        return false;
                    });
                }
            });
        }/**/
    });
</script>