<?php /*a:1:{s:64:"C:\wamp64\www\zbg\app\admin\view\order\withdraw_trade\index.html";i:1751004937;}*/ ?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">
            <form class="layui-form" lay-filter="withdrawTradeList-form-search">
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <div class="layui-input-group">
                            <input type="text" name="username" placeholder="玩家账号" class="layui-input">
                        </div>
                    </div>
                    <div class="layui-inline">
                        <div class="layui-btn-group">
                            <a class="layui-btn" lay-submit lay-filter="top-withdrawTradeList-search"><i class="layui-icon layui-icon-search layuiadmin-button-btn"></i> 搜索</a>
                            <a class="layui-btn" lay-submit lay-filter="top-withdrawTradeList-all"><i class="layui-icon layui-icon-light"></i>全部</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="layui-card-body">
            <table lay-filter="withdrawTradeList" id="withdrawTradeList"></table>
        </div>
    </div>
</div>
<script type="text/html" id="opWithdrawTemplated">
    <div class="layui-clear-space">
        <a class="layui-btn layui-btn-xs" lay-event="details">查看</a>
        {{# if (d.status == 1) { }}
        <a class="layui-btn layui-btn-xs" lay-event="payment">确认打款</a>
        {{# } }}
    </div>
</script>
<!--JS部分-->
<script type="text/javascript">
    let GAMES = <?php echo $game; ?>;
    let SERVERIDS = <?php echo $serverid; ?>;
    let TYPES = <?php echo $type; ?>;
    let WITHDRAW_STATUS = <?php echo $withdraw_status; ?>;

    layui.use(['buildItems'],function(){
        var map_root = layui.cache.maps;
        var app_root = map_root + 'order.withdrawTrade/';
        var table=layui.table,form=layui.form,admin=layui.admin;

        $('#top-items-add').on('click',function(){operateItemsData('add', []);});
        /*渲染数据*/
        table.render({
            elem: '#withdrawTradeList',
            url: app_root+"index?do=json",
            lineStyle: "height:60px",
            cols: [[
                {field:"id",title:"编号",width:80,align:'center'},
                {field:"game",title:"游戏",width:80,align:'center',templet:function (d) {
                        if (!d.game) {
                            return ""
                        }
                        return GAMES[d.game] || ''
                    }
                },
                {field:'serverid',title:'区服',width:80,align:'center',templet:function (d) {
                        if (!d.serverid) {
                            return ""
                        }
                        var serverid = SERVERIDS[d.game] || ""
                        if (!serverid) {
                            return ""
                        }

                        return serverid[d.serverid] || ''
                    }
                },
                {field:"orderno",title:"订单号",width:200,align:'center'},
                {field:"ordertype",title:"交易类型",width:100,align:'center',templet:function (d) {
                        return TYPES[d.ordertype] || ''
                    }
                },
                {field:"charge",title:"手续费",width:100,align:'center'},
                {field:"price",title:"价格",width:100,align:'center'},
                {field:"amount",title:"到账金额",width:100,align:'center'},
                {field:"tid",title:"交易编号",width:80,align:'center'},
                {field:"username",title:"账号",width:120,align:'center'},
                {field:"payuser",title:"姓名",width:100,align:'center'},
                {field:"status",title:"提现状态",width:100,align:'center',templet:function (d) {
                        var status = WITHDRAW_STATUS[d.status] || ""
                        if (!status) {
                            return ""
                        }

                        return WITHDRAW_STATUS[d.status] || ''
                    }
                },
                {field:"aliname",title:"支付宝账号",width:150,align:'center'},
                {field:"alitime_text",title:"申请时间",width:180,align:'center'},
                {field:"withdrawtime_text",title:"提现时间",width:180,align:'center'},
                {fixed: 'right', title:'操作', width: 120, templet: '#opWithdrawTemplated'}
            ]],
            page: true,
            limit:<?php echo htmlentities((string) $limit); ?>,
        });/**/
        /*监听搜索*/
        form.on('submit(top-withdrawTradeList-search)', function(data){
            table.reloadData('withdrawTradeList',{where:data.field,page:{curr:1}});
            return false;
        });/**/

        /*监听全部按钮*/
        form.on('submit(top-withdrawTradeList-all)', function(){
            table.reloadData('withdrawTradeList',{where:{type: 2},page:{curr:1}});
            return false;
        });/**/

        table.on('tool(withdrawTradeList)', function(obj) {
            if (obj.event === "details") {
                detailsItemsData(obj.data);
            } else if (obj.event === "payment") {
                paymentWithdraw(obj.data);
            }
        });

        function detailsItemsData(data)
        {
            layer.open({
                type: 2,
                area: ['800px', '600px'],
                title: "查看-" + data.id,
                content: app_root+"details?id="+data.id,
            });
        }

        // 交易下架
        function paymentWithdraw(data)
        {
            layer.confirm("您确定要给【"+data.payuser+"（"+data.aliname+"）】打款"+data.amount+"吗？", function () {
                var btn = $(this);
                if (btn.attr('stop')){return false;}else{btn.attr('stop',1)}
                admin.req(app_root+"payment",{orderno:data.orderno},function(res){
                    layer.msg(res.msg,{shade:[0.4,'#000'],time:1500},function(){
                        if(parseInt(res.code) === 1){
                            table.reloadData('withdrawTradeList');
                        }
                        btn.removeAttr('stop');
                    });
                },'post',{headersToken:true});
            })
        }
    });
</script>