<?php /*a:1:{s:55:"C:\wamp64\www\zbg\app\admin\view\trade\items\index.html";i:1751020081;}*/ ?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">
            <form class="layui-form" lay-filter="itemsList-form-search">
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <div class="layui-input-group">
                            <input type="text" name="itemname" placeholder="道具名称" class="layui-input">
                        </div>
                    </div>
                    <div class="layui-inline">
                        <div class="layui-btn-group">
                            <a class="layui-btn" lay-submit lay-filter="top-itemsList-search"><i class="layui-icon layui-icon-search layuiadmin-button-btn"></i> 搜索</a>
                            <a class="layui-btn" lay-submit lay-filter="top-itemsList-all"><i class="layui-icon layui-icon-light"></i>全部</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="layui-card-body">
            <div class="layui-card-box">
                <div class="layui-btn-group">
                    <a class="layui-btn" id="top-items-add"><i class="layui-icon layui-icon-add-circle"></i> 添加</a>
                </div>
            </div>
            <table lay-filter="itemsList" id="itemsList"></table>
        </div>
    </div>
</div>
<script type="text/html" id="opTemplated">
    <div class="layui-clear-space">
        <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
    </div>
</script>
<!--JS部分-->
<script type="text/javascript">
    let GAMES = <?php echo $game; ?>;
    let SERVERIDS = <?php echo $serverid; ?>;
    layui.use(['buildItems'],function(){
        var map_root = layui.cache.maps;
        var app_root = map_root + 'trade.items/';
        var table=layui.table,form=layui.form,admin=layui.admin;

        $('#top-items-add').on('click',function(){operateItemsData('add', []);});
        /*渲染数据*/
        table.render({
            elem: '#itemsList',
            url: app_root+"index?do=json",
            lineStyle: "height:60px",
            cols: [[
                {field:"id",title:"ID",width:80,align:'center',fixed:'left'},
                {field:"game",title:"游戏",width:80,align:'center',fixed:'left',templet:function (d) {
                        if (!d.game) {
                            return ""
                        }
                        return GAMES[d.game] || ''
                    }
                },
                {field:'serverid',title:'区服',width:80,align:'center',fixed:'left',templet:function (d) {
                        if (!d.serverid) {
                            return ""
                        }
                        var serverid = SERVERIDS[d.game] || ""
                        if (!serverid) {
                            return ""
                        }

                        return serverid[d.serverid] || ''
                    }
                },
                {field:'itemname',title:'道具名称',width:120,align:'center',fixed:'left'},
                {field:'iconset',title:'图片',width:80,align:'center',fixed:'left', templet: function (d) {
                        if (d.iconset) {
                            var res = calcXAndY(d);
                            return '<div style="background-image: url('+d.iconset+');background-position-x: '+res.x+'px;background-position-y: '+res.y+'px ; cursor: pointer;width:32px;height:32px;" />';
                            // return '<img src="' + d.iconset + '" style="cursor: pointer;width:36px;height:36px;" lay-event="pictures"/>';
                        } else {
                            return "";
                        }
                    }
                },
                {field:'text',title:'道具介绍',width:80,align:'center',hide:1},
                {field:'itemid',title:'道具ID',width:80,align:'center',fixed:'left'},
                {field:'icon',title:'背包内观',width:80,align:'center'},
                {field:'level',title:'使用等级',width:80,align:'center'},
                {field:'dex',title:'名称颜色',width:80,align:'center'},
                {field:'og',title:'绑定',width:80,align:'center'},
                {field:'attacktime',title:'攻速',width:80,align:'center'},
                {field:'effect1',title:'攻 击力下限',width:80,align:'center'},
                {field:'effect2',title:'攻击力浮动值',width:80,align:'center'},
                {field:'effect3',title:'防御力',width:80,align:'center'},
                {field:'effect4',title:'抵抗',width:80,align:'center'},
                {field:'consthp',title:'血量加成',width:80,align:'center'},
                {field:'constsp',title:'活力加成',width:80,align:'center'},
                {field:'constmp',title:'魔力加成',width:80,align:'center'},
                {field:'conststr',title:'力量加成',width:80,align:'center'},
                {field:'constdex',title:'敏捷加成',width:80,align:'center'},
                {field:'constrec',title:'体质加成',width:80,align:'center'},
                {field:'constint',title:'智力加成',width:80,align:'center'},
                {field:'constwis',title:'精神加成',width:80,align:'center'},
                {field:'constluc',title:'幸运加成',width:80,align:'center'},
                {field:'extduration',title:'时限',width:80,align:'center'},
                {fixed: 'right', title:'操作', width: 120, templet: '#opTemplated'}
            ]],
            page: true,
            limit:<?php echo htmlentities((string) $limit); ?>,
        });/**/
        /*监听搜索*/
        form.on('submit(top-itemsList-search)', function(data){
            table.reloadData('itemsList',{where:data.field,page:{curr:1}});
            return false;
        });/**/

        /*监听全部按钮*/
        form.on('submit(top-itemsList-all)', function(){
            table.reloadData('itemsList',{where:{type: 2},page:{curr:1}});
            return false;
        });/**/

        table.on('tool(itemsList)', function(obj) {
            if (obj.event === 'pictures') {
                if (obj.data.iconset) {
                    layer.photos({
                        photos: { // 构造layer.photos所需的JSON结构
                            data: [{src: obj.data.iconset}]
                        }
                    });
                }
            } else if (obj.event === "edit") {
                operateItemsData('edit', obj.data);
            } else if (obj.event === "add") {
                operateItemsData('add', obj.data);
            }
        });
        // 计算坐标值
        function calcXAndY(d)
        {
            var row = parseInt(d.icon / 16);
            var index = parseInt(d.icon % 16)
            // background-position: calc(-1 * (目标列索引 - 1) * 小图宽度) calc(-1 * (目标行索引 - 1) * 小图高度);
            if (index == 0) {
                index = 16;
                row = row - 1
            }
            var x = -1 * (index - 1) * 32;
            var y = -1 * (row) * 32;

            return {"x": x, "y": y}
        }
        // 编辑或编辑
        function operateItemsData(type, data) {

            var game = data.game;
            var serveridData = SERVERIDS[game] || {}
            var res = calcXAndY(data)
            var editOnly = [{name:"id",title:"ID",type:'html',html: '<input type="text" name="id" class="layui-input" disabled>', style:"width:80px"}];
            var commonFields = [{name:"game",title:"游戏",type:'select',options: GAMES,verify: 'required|game',reqtext:'请选择游戏',},
                {name:'serverid',title:'区服',type:'select',options: serveridData,verify: 'required|serverid',reqtext:'请选择区服',},
                {name:'itemname',title:'道具名称',type:'text',verify:'required|itemname',reqtext:'请输入道具名称',},
                {name:'iconset',title:'图片集合',type:'image',value: data?data.iconset:'',reqtext:'请上传道具图片' ,action:'items',gid:1},
                {name:'iconset_show',title:'图片',type:'html',html: '<div style="background-image: url('+data.iconset+');background-position-x: '+res.x+'px;background-position-y: '+res.y+'px ; cursor: pointer;width:32px;height:32px;" />'},
                {name:'text',title:'道具介绍',type:'textarea',verify:'required|text',reqtext:'请输入道具介绍',},
                {name:'itemid',title:'道具ID',type:'number',verify:'required|itemid',reqtext:'请输入道具ID',},
                {name:'icon',title:'背包内观',type:'number',verify:'required|icon',reqtext:'请填写背包内观',},
                {name:'level',title:'使用等级',type:'number',verify:'required|level',reqtext:'请填写使用等级',},
                {name:'dex',title:'名称颜色',type:'number',verify:'required|dex',reqtext:'请填写名称颜色',},
                {name:'og',title:'绑定',type:'number',verify:'required|og',reqtext:'请填写绑定',},
                {name:'attacktime',title:'攻速',type:'number',verify:'required|attacktime',reqtext:'请填写攻速',},
                {name:'effect1',title:'攻击力下限',type:'number',verify:'required|effect1',reqtext:'请填写攻击力下限',},
                {name:'effect2',title:'攻击力浮动值',type:'number',verify:'required|effect2',reqtext:'请填写攻击力浮动值',},
                {name:'effect3',title:'防御力',type:'number',verify:'required|effect3',reqtext:'请填写防御力',},
                {name:'effect4',title:'抵抗',type:'number',verify:'required|effect4',reqtext:'请填写抵抗',},
                {name:'consthp',title:'血量加成',type:'number',verify:'required|consthp',reqtext:'请填写血量加成',},
                {name:'constsp',title:'活力加成',type:'number',verify:'required|constsp',reqtext:'请填写活力加成',},
                {name:'constmp',title:'魔力加成',type:'number',verify:'required|constmp',reqtext:'请填写魔力加成',},
                {name:'conststr',title:'力量加成',type:'number',verify:'required|conststr',reqtext:'请填写力量加成',},
                {name:'constdex',title:'敏捷加成',type:'number',verify:'required|constdex',reqtext:'请填写敏捷加成',},
                {name:'constrec',title:'体质加成',type:'number',verify:'required|constrec',reqtext:'请填写体质加成',},
                {name:'constint',title:'智力加成',type:'number',verify:'required|constint',reqtext:'请填写智力加成',},
                {name:'constwis',title:'精神加成',type:'number',verify:'required|constwis',reqtext:'请填写精神加成',},
                {name:'constluc',title:'幸运加成',type:'number',verify:'required|constluc',reqtext:'请填写幸运加成',},
                {name:'extduration',title:'时限',type:'number',verify:'required|extduration',reqtext:'请填写时限',},
            ]

            var renderData = [];
            if (type == 'edit') {
                renderData = [...editOnly, ...commonFields]
            } else {
                renderData = commonFields
            }

            admin.open({
                type: 1,
                bid: 'items',
                btn: ['保存', '取消'],
                area: ['800px', '600px'],
                title: type == 'edit' ? '编辑-' + data.itemname : "添加道具",
                success: function(l,index){
                    layui.buildItems.build({
                        bid: 'items',
                        gid: 'items',
                        data: renderData
                    });
                    form.val('items_form',data);
                    form.verify({
                        game: function (v) {
                            if (!v) {
                                return "请选择游戏"
                            }
                        },
                        itemname: function (v) {
                            const isValid = /^.{0,80}$/.test(v);
                            if (!isValid) {
                                return "道具名称不能超过80个字符";
                            }
                        },
                        iconset: function (v) {
                            if (!v) {
                                return "请上传道具图片";
                            }
                        },
                        text: function (v) {
                            const isValid = /^.{0,255}$/.test(v);
                            if (!isValid) {
                                return "道具介绍不能超过255个字符";
                            }
                        },
                        itemid: function (v) { if (parseInt(v) < 0) {return "道具ID不能小于0";} },
                        icon: function (v) { if (parseInt(v) < -1) {return "背包内观不能小于-1";} },
                        level: function (v) { if (parseInt(v) < -1) {return "使用等级不能小于-1";} },
                        dex: function (v) { if (parseInt(v) < -1) {return "名称颜色不能小于-1";} },
                        og: function (v) { if (parseInt(v) < -1) {return "绑定不能小于-1";} },
                        attacktime: function (v) { if (parseInt(v) < -1) {return "攻速不能小于-1";} },
                        effect1: function (v) { if (parseInt(v) < -1) {return "攻击力下限不能小于-1";} },
                        effect2: function (v) { if (parseInt(v) < -1) {return "攻击力浮动值不能小于-1";} },
                        effect3: function (v) { if (parseInt(v) < -1) {return "防御力不能小于-1";} },
                        effect4: function (v) { if (parseInt(v) < -1) {return "抵抗不能小于-1";} },
                        consthp: function (v) { if (parseInt(v) < -1) {return "血量加成不能小于-1";} },
                        constsp: function (v) { if (parseInt(v) < -1) {return "活力加成不能小于-1";} },
                        constmp: function (v) { if (parseInt(v) < -1) {return "魔力加成不能小于-1";} },
                        conststr: function (v) { if (parseInt(v) < -1) {return "力量加成不能小于-1";} },
                        constdex: function (v) { if (parseInt(v) < -1) {return "敏捷加成不能小于-1";} },
                        constrec: function (v) { if (parseInt(v) < -1) {return "体质加成不能小于-1";} },
                        constint: function (v) { if (parseInt(v) < -1) {return "智力加成不能小于-1";} },
                        constwis: function (v) { if (parseInt(v) < -1) {return "精神加成不能小于-1";} },
                        constluc: function (v) { if (parseInt(v) < -1) {return "幸运加成不能小于-1";} },
                        extduration: function (v) { if (parseInt(v) < -1) {return "时限不能小于-1";} },
                    });
                    form.on('submit(items)',function(data){
                        var btn = $(this);
                        if (btn.attr('stop')){return false}else{btn.attr('stop',1)}
                        admin.req(app_root+type,data.field,function(res){
                            layer.msg(res.msg,{shade:[0.4,'#000'],time:1500},function(){
                                if(res.code==1){
                                    layer.close(index);
                                    table.reloadData('itemsList');
                                }
                                btn.removeAttr('stop');
                            });
                        },'post',{headersToken:true});
                        return false;
                    });

                    form.on('select(game)', function (data) {
                        var game = data.value
                        var selData = SERVERIDS[game] || {}
                        const select =$('select[name="serverid"]');

                        var option = "";
                        for (const key in selData) {
                            option += ("<option value=" + key + ">" + selData[key]+ "</option>");
                        }

                        select.html(option);
                        form.render('select');//渲染select
                    });
                }
            });
        }
    });
</script>