<?php /*a:1:{s:53:"C:\wamp64\www\zbg\app\admin\view\help\cate\index.html";i:1749263318;}*/ ?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">
            <form class="layui-form" lay-filter="helpCateLists-form-search">
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <div class="layui-input-group">
                            <input type="text" name="name" placeholder="分类名称" class="layui-input">
                        </div>
                    </div>
                    <div class="layui-inline">
                        <div class="layui-btn-group">
                            <a class="layui-btn" lay-submit lay-filter="top-helpCateLists-search"><i class="layui-icon layui-icon-search layuiadmin-button-btn"></i> 搜索</a>
                            <a class="layui-btn" lay-submit lay-filter="top-helpCateLists-all"><i class="layui-icon layui-icon-light"></i>全部</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="layui-card-body">
            <div class="layui-card-box">
                <div class="layui-btn-group">
                    <a class="layui-btn" id="top-items-add"><i class="layui-icon layui-icon-add-circle"></i> 添加</a>
                </div>
            </div>
            <table lay-filter="helpCateLists" id="helpCateLists"></table>
        </div>
    </div>
</div>
<script type="text/html" id="opHelpCateTemplated">
    <div class="layui-clear-space">
        <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
    </div>
</script>
<!--JS部分-->
<script type="text/javascript">
    layui.use(['buildItems'],function(){
        var map_root = layui.cache.maps;
        var app_root = map_root + 'help.cate/';
        var table=layui.table,form=layui.form,admin=layui.admin;

        $('#top-items-add').on('click',function(){operateData('add', []);});
        /*渲染数据*/
        table.render({
            elem: '#helpCateLists',
            url: app_root+"index?do=json",
            lineStyle: "height:60px",
            cols: [[
                {field:"id",title:"ID",width:80,align:'center',},
                {field:'name',title:'分类名称',width:180,align:'center',},
                {field:'sort',title:'排序',width:120,align:'center'},
                {field:'status',title:'状态',width:120,align:'center', templet:function(d){
                    if (d.status == 0) {
                        return "关闭";
                    }

                    return "开启";
                }},
                {fixed: 'right', title:'操作', width: 240, templet: '#opHelpCateTemplated'}
            ]],
            page: true,
            limit:<?php echo htmlentities((string) $limit); ?>,
        });/**/
        /*监听搜索*/
        form.on('submit(top-helpCateLists-search)', function(data){
            table.reloadData('helpCateLists',{where:data.field,page:{curr:1}});
            return false;
        });/**/

        /*监听全部按钮*/
        form.on('submit(top-helpCateLists-all)', function(){
            table.reloadData('helpCateLists',{where:{type: 2},page:{curr:1}});
            return false;
        });/**/

        table.on('tool(helpCateLists)', function(obj) {
            if (obj.event === "edit") {
                operateData('edit', obj.data);
            } else if (obj.event === "add") {
                operateData('add', obj.data);
            }
        });

        // 编辑或编辑
        function operateData(type, data) {

            var renderData = [
                {name:"id",type: 'hidden'},
                {name:'name',title:'分类名称',type:'text',verify:'required|name',reqtext:'请输入分类名称',},
                {name:'sort',title:'排序',type:'number', value: 0,verify:'required'},
                {name:"status",title:"状态",type:"switch",value:'1',verify:'required'},
                ]


            admin.open({
                type: 1,
                bid: 'cate',
                btn: ['保存', '取消'],
                area: ['800px', '600px'],
                title: type == 'edit' ? '编辑-' + data.name : "添加道具",
                success: function(l,index){
                    layui.buildItems.build({
                        bid: 'cate',
                        gid: 'cate',
                        data: renderData
                    });
                    form.val('cate_form',data);
                    form.verify({
                        name: function (v) {
                            const isValid = /^.{0,80}$/.test(v);
                            if (!isValid) {
                                return "分类名称不能超过80个字符";
                            }
                        }
                    });
                    form.on('submit(cate)',function(data){
                        var btn = $(this);
                        if (btn.attr('stop')){return false}else{btn.attr('stop',1)}
                        var field = data.field;
                        field.status  = field.hasOwnProperty('status') ? field.status : '0';
                        admin.req(app_root+type,data.field,function(res){
                            layer.msg(res.msg,{shade:[0.4,'#000'],time:1500},function(){
                                if(res.code==1){
                                    layer.close(index);
                                    table.reloadData('helpCateLists');
                                }
                                btn.removeAttr('stop');
                            });
                        },'post',{headersToken:true});
                        return false;
                    });
                }
            });
        }
    });
</script>