<?php /*a:1:{s:61:"C:\wamp64\www\zbg\app\admin\view\order\stats_trade\index.html";i:1751019889;}*/ ?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">
            <form class="layui-form" lay-filter="statsTradeList-form-search">
                <div class="layui-form-item">
                    <div class="layui-inline" style="width:110px;"><select name="game" id="search_game_select" lay-filter="game-search"></select></div>
                    <div class="layui-inline" style="width:180px;"><select name="serverid" id="search_serverid_select"></select></div>
                    <div class="layui-inline" style="width:100px;"><select name="ordertype" id="search_ordertype_select"></select></div>
                    <div class="layui-inline" style="width:192px;"><input type="text" name="statstime" id="stats-search-time" placeholder="统计日期" autocomplete="off" class="layui-input" lay-affix="clear"/></div>
                    <div class="layui-inline">
                        <div class="layui-btn-group">
                            <a class="layui-btn" lay-submit lay-filter="top-statsTradeList-search"><i class="layui-icon layui-icon-search layuiadmin-button-btn"></i> 搜索</a>
                            <a class="layui-btn" lay-submit lay-filter="top-statsTradeList-all"><i class="layui-icon layui-icon-light"></i>全部</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="layui-card-body">
            <table lay-filter="statsTradeList" id="statsTradeList"></table>
        </div>
    </div>
</div>
<script type="text/html" id="opStatsTemplated">
    <div class="layui-clear-space">
    </div>
</script>
<!--JS部分-->
<script type="text/javascript">
    let GAMES = <?php echo $game; ?>;
    let SERVERIDS = <?php echo $serverid; ?>;
    let ORDERTYPES = <?php echo $ordertype; ?>;
    let TYPES = <?php echo $type; ?>;
    // 交易类型
    var ordertypeSelect = '<option value="-1">全部</option>'; $.each(ORDERTYPES,function(k,v){ordertypeSelect += '<option value="'+ k +'">'+ v +'</option>';});
    var gameSelect = ''; $.each(GAMES,function(k,v){gameSelect += '<option value="'+ k +'">'+ v +'</option>';});
    var serveridSelect = '<option value="0">请选择区服</option>';


    layui.use(['buildItems'],function(){
        var map_root = layui.cache.maps;
        var app_root = map_root + 'order.statsTrade/';
        var table=layui.table,form=layui.form,admin=layui.admin;

        $('#top-items-add').on('click',function(){operateItemsData('add', []);});

        $('#search_ordertype_select').html(ordertypeSelect);
        $('#search_game_select').html(gameSelect);
        $('#search_serverid_select').html(serveridSelect);
        //渲染搜索元素
        form.render(null, 'statsTradeList-form-search');
        layui.laydate.render({elem:'#stats-search-time',range:true,format:'yyyy-MM-dd',done:function(){$('#stats-search-time').trigger('input')}});
        /*渲染数据*/
        table.render({
            elem: '#statsTradeList',
            url: app_root+"index?do=json",
            lineStyle: "height:60px",
            totalRow: true,
            cols: [[
                {field:"id",title:"编号",width:80,align:'center', totalRow: '合计：'},
                {field:"game",title:"游戏",width:80,align:'center',templet:function (d) {
                        if (!d.game) {
                            return ""
                        }
                        return GAMES[d.game] || ''
                    }
                },
                {field:'serverid',title:'区服',width:80,align:'center',templet:function (d) {
                        if (!d.serverid) {
                            return ""
                        }
                        var serverid = SERVERIDS[d.game] || ""
                        if (!serverid) {
                            return ""
                        }

                        return serverid[d.serverid] || ''
                    }
                },
                {field:"type",title:"统计类型",width:100,align:'center', templet: function (d) {
                        return TYPES[d.type] || '--'
                    }
                },
                {field:"ordertype",title:"交易类型",width:100,align:'center', templet: function (d) {
                        if (d.ordertype == -1) {
                            return "--";
                        }

                        return ORDERTYPES[d.ordertype] || '--'
                    }
                },
                {field:"stats_date",title:"日期",width:120,align:'center'},
                {field:"total_price",title:"总支付金额",width:100,align:'center'},
                {field:"total_withdraw",title:"总提现金额",width:100,align:'center'},
                {field:"total_charge",title:"总手续费",width:80,align:'center'},
                {field:"created_at",title:"添加时间",width:180,align:'center'},
                {fixed: 'right', title:'操作', templet: '#opStatsTemplated'}
            ]],
            page: true,
            limit:<?php echo htmlentities((string) $limit); ?>,
        });/**/

        form.on('select(game-search)', function (data) {
            var game = data.value
            var selData = SERVERIDS[game] || {}
            const select =$('select[name="serverid"]');

            var option = "";
            for (const key in selData) {
                console.log(key)
                option += ("<option value=" + key + ">" + selData[key]+ "</option>");
            }

            select.html(option);
            form.render('select');//渲染select
        });

        /*监听搜索*/
        form.on('submit(top-statsTradeList-search)', function(data){
            table.reloadData('statsTradeList',{where:data.field,page:{curr:1}});
            return false;
        });/**/

        /*监听全部按钮*/
        form.on('submit(top-statsTradeList-all)', function(){
            table.reloadData('statsTradeList',{where:{type: 0, ordertype: -1},page:{curr:1}});
            return false;
        });/**/

        table.on('tool(statsTradeList)', function(obj) {
            if (obj.event === "details") {
                detailsItemsData(obj.data);
            } else if (obj.event === "close") {
                closeTrade(obj.data.id);
            }
        });
    });
</script>