<?php /*a:1:{s:62:"C:\wamp64\www\zbg\app\admin\view\order\notice_trade\index.html";i:1749263381;}*/ ?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">
            <form class="layui-form" lay-filter="noticeTradeList-form-search">
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <div class="layui-input-group">
                            <input type="text" name="username" placeholder="玩家账号" class="layui-input">
                        </div>
                    </div>
                    <div class="layui-inline">
                        <div class="layui-btn-group">
                            <a class="layui-btn" lay-submit lay-filter="top-noticeTradeList-search"><i class="layui-icon layui-icon-search layuiadmin-button-btn"></i> 搜索</a>
                            <a class="layui-btn" lay-submit lay-filter="top-noticeTradeList-all"><i class="layui-icon layui-icon-light"></i>全部</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="layui-card-body">
            <table lay-filter="noticeTradeList" id="noticeTradeList"></table>
        </div>
    </div>
</div>
<script type="text/html" id="opNoticeTemplated">
    <div class="layui-clear-space">
        <a class="layui-btn layui-btn-xs" lay-event="details">查看</a>
    </div>
</script>
<!--JS部分-->
<script type="text/javascript">
    let GAMES = <?php echo $game; ?>;
    let SERVERIDS = <?php echo $serverid; ?>;
    let TYPES = <?php echo $type; ?>;

    layui.use(['buildItems'],function(){
        var map_root = layui.cache.maps;
        var app_root = map_root + 'order.noticeTrade/';
        var table=layui.table,form=layui.form,admin=layui.admin;

        $('#top-items-add').on('click',function(){operateItemsData('add', []);});
        /*渲染数据*/
        table.render({
            elem: '#noticeTradeList',
            url: app_root+"index?do=json",
            lineStyle: "height:60px",
            cols: [[
                {field:"id",title:"编号",width:80,align:'center'},
                {field:"game",title:"游戏",width:80,align:'center',templet:function (d) {
                        if (!d.game) {
                            return ""
                        }
                        return GAMES[d.game] || ''
                    }
                },
                {field:'serverid',title:'区服',width:80,align:'center',templet:function (d) {
                        if (!d.serverid) {
                            return ""
                        }
                        var serverid = SERVERIDS[d.game] || ""
                        if (!serverid) {
                            return ""
                        }

                        return serverid[d.serverid] || ''
                    }
                },
                {field:"tid",title:"交易编号",width:80,align:'center'},
                {field:"type",title:"交易类型",width:100,align:'center',templet:function (d) {
                        return TYPES[d.type] || ''
                    }
                },
                {field:"orderno",title:"订单号",width:200,align:'center'},
                {field:"username",title:"账号",width:120,align:'center'},
                {field:"title",title:"标题",width:200,align:'center'},
                {field:"created_at",title:"添加时间",width:180,align:'center'},
                {fixed: 'right', title:'操作', width: 120, templet: '#opNoticeTemplated'}
            ]],
            page: true,
            limit:<?php echo htmlentities((string) $limit); ?>,
        });/**/
        /*监听搜索*/
        form.on('submit(top-noticeTradeList-search)', function(data){
            table.reloadData('noticeTradeList',{where:data.field,page:{curr:1}});
            return false;
        });/**/

        /*监听全部按钮*/
        form.on('submit(top-noticeTradeList-all)', function(){
            table.reloadData('noticeTradeList',{where:{type: 2},page:{curr:1}});
            return false;
        });/**/

        table.on('tool(noticeTradeList)', function(obj) {
            if (obj.event === "details") {
                detailsItemsData(obj.data);
            }
        });

        function detailsItemsData(data)
        {
            layer.open({
                type: 2,
                area: ['800px', '600px'],
                title: "查看-" + data.id,
                content: app_root+"details?id="+data.id,
            });
        }
    });
</script>