<?php /*a:1:{s:60:"C:\wamp64\www\zbg\app\admin\view\order\prop_trade\index.html";i:1749542948;}*/ ?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">
            <form class="layui-form" lay-filter="propTradeList-form-search">
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <div class="layui-input-group">
                            <input type="text" name="username" placeholder="玩家账号" class="layui-input">
                        </div>
                    </div>
                    <div class="layui-inline">
                        <div class="layui-btn-group">
                            <a class="layui-btn" lay-submit lay-filter="top-propTradeList-search"><i class="layui-icon layui-icon-search layuiadmin-button-btn"></i> 搜索</a>
                            <a class="layui-btn" lay-submit lay-filter="top-propTradeList-all"><i class="layui-icon layui-icon-light"></i>全部</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="layui-card-body">
            <table lay-filter="propTradeList" id="propTradeList"></table>
        </div>
    </div>
</div>
<script type="text/html" id="opPropTemplated">
    <div class="layui-clear-space">
        <a class="layui-btn layui-btn-xs" lay-event="details">查看</a>
        {{# if (d.trade_status == 0 || d.trade_status == 1 || d.trade_status == 2) { }}
        <a class="layui-btn layui-btn-xs layui-btn-danger" lay-event="close">下架</a>
        {{# } }}
    </div>
</script>
<!--JS部分-->
<script type="text/javascript">
    let GAMES = <?php echo $game; ?>;
    let SERVERIDS = <?php echo $serverid; ?>;
    let API_STATUS = <?php echo $api_status; ?>;
    let PAY_STATUS = <?php echo $pay_status; ?>;
    let TRADE_STATUS = <?php echo $trade_status; ?>;
    let WITHDRAW_STATUS = <?php echo $withdraw_status; ?>;

    layui.use(['buildItems'],function(){
        var map_root = layui.cache.maps;
        var app_root = map_root + 'order.propTrade/';
        var table=layui.table,form=layui.form,admin=layui.admin;

        $('#top-items-add').on('click',function(){operateItemsData('add', []);});
        /*渲染数据*/
        table.render({
            elem: '#propTradeList',
            url: app_root+"index?do=json",
            lineStyle: "height:60px",
            cols: [[
                {field:"id",title:"编号",width:80,align:'center',fixed: true},
                {field:"game",title:"游戏",width:80,fixed: true,align:'center',templet:function (d) {
                        if (!d.game) {
                            return ""
                        }
                        return GAMES[d.game] || ''
                    }
                },
                {field:'serverid',title:'区服',width:80,fixed: true,align:'center',templet:function (d) {
                        if (!d.serverid) {
                            return ""
                        }
                        var serverid = SERVERIDS[d.game] || ""
                        if (!serverid) {
                            return ""
                        }

                        return serverid[d.serverid] || ''
                    }
                },
                {field:"num",title:"道具数量",width:100,fixed: true,align:'center'},
                {field:"username",title:"账号",width:100,fixed: true,align:'center'},
                {field:"tousername",title:"目标账号",width:100,align:'center'},
                {field:"amount",title:"到账金额",width:80,align:'center'},
                {field:"price",title:"价格",width:80,align:'center'},
                {field:"charge",title:"手续费",width:80,align:'center'},
                {field:"created_at",title:"添加时间",width:180,align:'center'},
                {field:"outtime_text",title:"剩余时间",width:120,align:'center',templet: function (d) {
                        return d.outtime_text;
                    }
                },
                {field:"pay_status",title:"支付状态",width:100,align:'center',templet: function (d) {
                        return PAY_STATUS[d.pay_status] || "";
                    }
                },
                {field:"trade_status",title:"状态",width:100,align:'center',templet: function (d) {
                        return TRADE_STATUS[d.trade_status] || "";
                    }
                },
                {field:"api_status ",title:"发送状态",width:100,align:'center',templet: function (d) {
                        return API_STATUS[d.api_status] || "";
                    }
                },
                {fixed: 'right', title:'操作', width: 120, templet: '#opPropTemplated'}
            ]],
            page: true,
            limit:<?php echo htmlentities((string) $limit); ?>,
        });/**/
        /*监听搜索*/
        form.on('submit(top-propTradeList-search)', function(data){
            table.reloadData('propTradeList',{where:data.field,page:{curr:1}});
            return false;
        });/**/

        /*监听全部按钮*/
        form.on('submit(top-propTradeList-all)', function(){
            table.reloadData('propTradeList',{where:{type: 2},page:{curr:1}});
            return false;
        });/**/

        table.on('tool(propTradeList)', function(obj) {
            if (obj.event === "details") {
                detailsItemsData(obj.data);
            } else if (obj.event === "close") {
                closeTrade(obj.data.id);
            }
        });

        function detailsItemsData(data)
        {
            layer.open({
                type: 2,
                area: ['1200px', '800px'],
                title: "查看-" + data.id,
                content: app_root+"details?id="+data.id,
            });
        }
        // 交易下架
        function closeTrade(id)
        {
            layer.confirm("您确定要下架吗？", function () {
                var btn = $(this);
                if (btn.attr('stop')){return false;}else{btn.attr('stop',1)}
                admin.req(app_root+"close",{id:id},function(res){
                    layer.msg(res.msg,{shade:[0.4,'#000'],time:1500},function(){
                        if(parseInt(res.code) === 1){
                            table.reloadData('propTradeList');
                        }
                        btn.removeAttr('stop');
                    });
                },'post',{headersToken:true});
            })
        }
    });
</script>