<?php
/* *
 * 功能：支付宝转账
 * 版本：2.0
 * 修改日期：2017-05-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 */

require_once dirname(dirname(dirname ( __FILE__ ))).'/AopSdk.php';

class AlipayTransferService {

    //支付宝网关地址
    public $gateway_url = "https://openapi.alipay.com/gateway.do";

    //支付宝公钥
    public $alipay_public_key;

    //商户私钥
    public $private_key;

    //应用证书地址
    public $app_cert_sn;
    //支付宝根证书地址
    public $alipay_root_cert_sn;

    //应用id
    public $appid;

    //编码格式
    public $charset = "UTF-8";

    public $token = NULL;

    //返回数据格式
    public $format = "json";

    //签名方式
    public $signtype = "RSA2";

    //日志路径
    public $log_path;

    function __construct($alipay_config){
        $this->gateway_url = $alipay_config['gatewayUrl'];
        $this->appid = $alipay_config['app_id'];
        $this->private_key = $alipay_config['merchant_private_key'];
        $this->alipay_public_key = $alipay_config['alipay_public_key'];
        $this->charset = $alipay_config['charset'];
        $this->signtype=$alipay_config['sign_type'];
        $this->alipay_root_cert_sn=$alipay_config['alipay_root_cert_sn'];
        $this->app_cert_sn=$alipay_config['app_cert_sn'];
        $this->log_path = $alipay_config['log_path'];

        if(empty($this->appid)||trim($this->appid)==""){
            throw new Exception("appid should not be NULL!");
        }
        if(empty($this->private_key)||trim($this->private_key)==""){
            throw new Exception("private_key should not be NULL!");
        }
        if(empty($this->alipay_public_key)||trim($this->alipay_public_key)==""){
            throw new Exception("alipay_public_key should not be NULL!");
        }
        if(empty($this->charset)||trim($this->charset)==""){
            throw new Exception("charset should not be NULL!");
        }
        if(empty($this->gateway_url)||trim($this->gateway_url)==""){
            throw new Exception("gateway_url should not be NULL!");
        }
        if(empty($this->app_cert_sn)||trim($this->app_cert_sn)==""){
            throw new Exception("app_cert_sn should not be NULL!");
        }
        if(empty($this->alipay_root_cert_sn)||trim($this->alipay_root_cert_sn)==""){
            throw new Exception("alipay_root_cert_sn should not be NULL!");
        }

    }

    /**
     * alipay.fund.trans.uni.transfer
     * @param $builder
     * @return $1|false|mixed|SimpleXMLElement
     */
    function transferuni($builder) {

        $biz_content=$builder->getBizContent();
        //打印业务参数
        $this->writeLog($biz_content);

        $request = new AlipayFundTransUniTransferRequest();

        $request->setBizContent ( $biz_content );

        // 首先调用支付api
        $response = $this->aopcertclientRequestExecute($request);
        $response = $response->alipay_fund_trans_uni_transfer_response;
        return $response;
    }

    /**
     * sdkClient - 证书模式
     * @param $request 接口请求参数对象。
     * @param $ispage  是否是页面接口，电脑网站支付是页面表单接口。
     * @return $response 支付宝返回的信息
     */
    function aopcertclientRequestExecute($request,$ispage=false) {
        $aop = new AopCertClient();
        $aop->appId = $this->appid;
        $aop->format= $this->format;
        $aop->gatewayUrl = $this->gateway_url;
        $aop->signType=$this->signtype;
        $aop->postCharset = $this->charset;
        $aop->apiVersion ="1.0";
        $aop->rsaPrivateKey =  $this->private_key;
        $aop->alipayrsaPublicKey = $aop->getPublicKey($this->alipay_public_key);
        $aop->appCertSN = $aop->getCertSN($this->app_cert_sn);
        $aop->alipayRootCertSN = $aop->getRootCertSN($this->alipay_root_cert_sn);
        // 开启页面信息输出
        $aop->debugInfo=true;
        $result = $aop->execute($request);

        //打开后，将报文写入log文件
        $this->writeLog("response: ".var_export($result,true));
        return $result;
    }

    /**
     * 验签方法
     * @param $arr 验签支付宝返回的信息，使用支付宝公钥。
     * @return boolean
     */
    function check($arr){
        $aop = new AopClient();
        $aop->alipayrsaPublicKey = $this->alipay_public_key;
        $result = $aop->rsaCheckV1($arr, $this->alipay_public_key, $this->signtype);

        return $result;
    }

    /**
     * 请确保项目文件有可写权限，不然打印不了日志。
     */
    function writeLog($text) {
        // $text=iconv("GBK", "UTF-8//IGNORE", $text);
        //$text = characet ( $text );

        if(!empty($this->log_path) && trim($this->log_path)!=""){
            $dir = dirname($this->log_path);
            if(!is_dir($dir)){
                mkdir($dir,0777,true);
            }

            file_put_contents ( $this->log_path, date ( "Y-m-d H:i:s" ) . "  " . $text . "\r\n", FILE_APPEND );
        }
    }
}