<?php

namespace alipay\pagepay\buildermodel;

class AlipayTransUniTranserBuilder
{
    //设置商家侧唯一订单号
    private $outBizNo = "";

    //设置订单总金额
    private $transAmount = "";

    //设置描述特定的业务场景
    private $bizScene = "";

    // 设置业务产品码
    private $productCode = "";

    // 设置转账业务的标题
    private $orderTitle = "";

    // 设置收款方信息
    private $payeeInfo = [];

    // 设置业务备注
    private $remark = "";

    // 设置转账业务请求的扩展参数
    private $businessParams = "";

    private $bizContentarr = [];

    private $bizContent = NULL;

    public function getBizContent()
    {
        if(!empty($this->bizContentarr)){
            $this->bizContent = json_encode($this->bizContentarr,JSON_UNESCAPED_UNICODE);
        }
        return $this->bizContent;
    }

    public function getOutBizNo(): string
    {
        return $this->outBizNo;
    }

    public function setOutBizNo(string $outBizNo): void
    {
        $this->outBizNo = $outBizNo;
        $this->bizContentarr['out_biz_no'] = $outBizNo;
    }

    public function getTransAmount(): string
    {
        return $this->transAmount;
    }

    public function setTransAmount(string $transAmount): void
    {
        $this->transAmount = $transAmount;
        $this->bizContentarr['trans_amount'] = $transAmount;
    }

    public function getBizScene(): string
    {
        return $this->bizScene;
    }

    public function setBizScene(string $bizScene): void
    {
        $this->bizScene = $bizScene;
        $this->bizContentarr['biz_scene'] = $bizScene;
    }

    public function getProductCode(): string
    {
        return $this->productCode;
    }

    public function setProductCode(string $productCode): void
    {
        $this->productCode = $productCode;
        $this->bizContentarr['product_code'] = $productCode;
    }

    public function getOrderTitle(): string
    {
        return $this->orderTitle;
    }

    public function setOrderTitle(string $orderTitle): void
    {
        $this->orderTitle = $orderTitle;
        $this->bizContentarr['order_title'] = $orderTitle;
    }

    public function getPayeeInfo(): array
    {
        return $this->payeeInfo;
    }

    public function setPayeeInfo(array $payeeInfo): void
    {
        $this->payeeInfo = $payeeInfo;
        $this->bizContentarr['payee_info'] = $payeeInfo;
    }

    public function getRemark(): string
    {
        return $this->remark;
    }

    public function setRemark(string $remark): void
    {
        $this->remark = $remark;
        $this->bizContentarr['remark'] = $remark;
    }

    public function getBusinessParams(): string
    {
        return $this->businessParams;
    }

    public function setBusinessParams(string $businessParams): void
    {
        $this->businessParams = $businessParams;
        $this->bizContentarr['business_params'] = $businessParams;
    }
}