<?php

use app\common\constant\SyncItem;
use app\common\model\Trade;

return [
    'open_key'            => env('shaiya.open_key', ''), // 对外sign，key
    'serve'               => env('shaiya.serve', ''),
    'key'                 => env('shaiya.key', ''),
    'sync_item_flow'      => [ // 1,2,3,4,5,6,7 区服
        1 => [
            Trade::TYPE_GOLD  => [SyncItem::STEP_UPPER],
            Trade::TYPE_ROLES => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS, SyncItem::STEP_PACKSACK, SyncItem::STEP_ROLE_BACKPACK, SyncItem::STEP_ROLE_GOD, SyncItem::STEP_ROLE_WING],
            Trade::TYPE_PROP  => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS],
        ],
        2 => [
            Trade::TYPE_GOLD  => [SyncItem::STEP_UPPER],
            Trade::TYPE_ROLES => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS, SyncItem::STEP_PACKSACK, SyncItem::STEP_ROLE_BACKPACK],
            Trade::TYPE_PROP  => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS],
        ],
        3 => [
            Trade::TYPE_GOLD  => [SyncItem::STEP_UPPER],
            Trade::TYPE_ROLES => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS, SyncItem::STEP_PACKSACK, SyncItem::STEP_ROLE_BACKPACK],
            Trade::TYPE_PROP  => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS],
        ],
        4 => [
            Trade::TYPE_GOLD  => [SyncItem::STEP_UPPER],
            Trade::TYPE_ROLES => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS, SyncItem::STEP_PACKSACK, SyncItem::STEP_ROLE_BACKPACK],
            Trade::TYPE_PROP  => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS],
        ],
        5 => [
            Trade::TYPE_GOLD  => [SyncItem::STEP_UPPER],
            Trade::TYPE_ROLES => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS, SyncItem::STEP_PACKSACK, SyncItem::STEP_ROLE_BACKPACK],
            Trade::TYPE_PROP  => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS],
        ],
        6 => [
            Trade::TYPE_GOLD  => [SyncItem::STEP_UPPER],
            Trade::TYPE_ROLES => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS, SyncItem::STEP_PACKSACK, SyncItem::STEP_ROLE_BACKPACK, SyncItem::STEP_FACADE],
            Trade::TYPE_PROP  => [SyncItem::STEP_UPPER, SyncItem::STEP_DETAILS],
        ],
    ],
    'role_item_details_tips' => [ // 角色详情，道具tab的tips
        'equip_tips'    => "装备属性为养成属性合计，非基础属性！",
        'backpack_tips' => "限时道具无法在此查看剩余有效时间！装备无法查看养成属性！",
        'rolepack_tips' => "限时道具无法在此查看剩余有效时间！装备无法查看养成属性！",
        'facade_tips'   => "仅展示背包与角色仓库中传说及以上品质的永久外观！",
    ],
    'transfer'            => [
        'sendname'  => '珍宝阁购买',
        'sendcontent'=> '珍宝阁购买道具发放',
        'TradeGold' => [
            'goods_sn'   => 94008,// 金币转移道具ID-正式-94008,测试服ID-30001
            'goods_name' => "金币",
        ],
        'TradeRole' => [
        ],
        'TradeProp' => [
        ],
    ],
    'gold_num_ratio'      => 1000, // 金币数量 1个金币代表1000w，修改需慎重
    'role_kill_ratio'     => 100, // 战功，除以100
    'order_error_message' => [0 => '账号不存在或已封禁', 2 => '角色槽已满不能购买', 3 => '当前账号不符合熊灵族购买条件', 4 => '商品所属账号已封停', 5 => '角色状态异常不可购买'],
    'war_type'                => [
        0 => [
            'label' => "普通模式",
            'tips'  => "包含当前角色属性、穿戴装备（不含合金）外观属性、天神翅膀结婚系统属性",
        ],
        1 => [
            'label' => "战一模式",
            'tips'  => "包含当前角色属性、穿戴装备（不含合金）外观属性"
        ],
        2 => [
            'label' => "战二模式",
            'tips'  => "包含当前角色属性、穿戴装备（不含合金）外观属性"
        ]
    ],
    'equip_type'                => [
        0 => [
            'label' => "普通模式",
        ],
        1 => [
            'label' => "战一模式",
        ],
        2 => [
            'label' => "战二模式",
        ]
    ],
    // 阵营
    'family'              => [0 => "光之同盟", 1 => "愤怒联合", 2 => "光之同盟", 3 => "愤怒联合", 4 => "光之同盟", 5 => "愤怒联合"],
    'job_bit'             => [
        0 => "拳刹", 1 => "祭司", 2 => " 巫师", 3 => "猎人", 4 => " 潜行者", 5 => "护卫", 6 => "斗士",
        7 => "斗魂", 8 => "牧师", 9 => "魔法师", 10 => "弓箭手", 11 => "刺客", 12 => "圣骑士", 13 => "战士",
    ],
    // 职业
    'job' => [
        0 => [
            0 => ["name" => "战士", "head" => "/storage/images/roles/worrior.png"],
            1 => ["name" => "圣骑士", "head" => "/storage/images/roles/guardian.png"],
            2 => ["name" => "刺客", "head" => "/storage/images/roles/assassin.png"],
            3 => ["name" => "弓箭手", "head" => "/storage/images/roles/archer.png"],
            4 => ["name" => "魔法师", "head" => "/storage/images/roles/pagan.png"],
            5 => ["name" => "牧师", "head" => "/storage/images/roles/oracle.png"],
            6 => ["name" => "斗魂", "head" => "/storage/images/roles/panda.png"],
        ],
        1 => [
            0 => ["name" => "战士", "head" => "/storage/images/roles/worrior.png"],
            1 => ["name" => "圣骑士", "head" => "/storage/images/roles/guardian.png"],
            2 => ["name" => "刺客", "head" => "/storage/images/roles/assassin.png"],
            3 => ["name" => "弓箭手", "head" => "/storage/images/roles/archer.png"],
            4 => ["name" => "魔法师", "head" => "/storage/images/roles/pagan.png"],
            5 => ["name" => "牧师", "head" => "/storage/images/roles/oracle.png"],
            6 => ["name" => "斗魂", "head" => "/storage/images/roles/panda.png"],
        ],
        2 => [
            0 => ["name" => "斗士", "head" => "/storage/images/roles/worrior1.png"],
            1 => ["name" => "护卫", "head" => "/storage/images/roles/guardian1.png"],
            2 => ["name" => "潜行者", "head" => "/storage/images/roles/assassin1.png"],
            3 => ["name" => "猎人", "head" => "/storage/images/roles/archer1.png"],
            4 => ["name" => "巫师", "head" => "/storage/images/roles/pagan1.png"],
            5 => ["name" => "祭司", "head" => "/storage/images/roles/oracle1.png"],
            6 => ["name" => "拳刹", "head" => "/storage/images/roles/panda1.png"],
        ],
        3 => [
            0 => ["name" => "斗士", "head" => "/storage/images/roles/worrior1.png"],
            1 => ["name" => "护卫", "head" => "/storage/images/roles/guardian1.png"],
            2 => ["name" => "潜行者", "head" => "/storage/images/roles/assassin1.png"],
            3 => ["name" => "猎人", "head" => "/storage/images/roles/archer1.png"],
            4 => ["name" => "巫师", "head" => "/storage/images/roles/pagan1.png"],
            5 => ["name" => "祭司", "head" => "/storage/images/roles/oracle1.png"],
            6 => ["name" => "拳刹", "head" => "/storage/images/roles/panda1.png"],
        ],
        4 => [
            0 => ["name" => "战士", "head" => "/storage/images/roles/worrior.png"],
            1 => ["name" => "圣骑士", "head" => "/storage/images/roles/guardian.png"],
            2 => ["name" => "刺客", "head" => "/storage/images/roles/assassin.png"],
            3 => ["name" => "弓箭手", "head" => "/storage/images/roles/archer.png"],
            4 => ["name" => "魔法师", "head" => "/storage/images/roles/pagan.png"],
            5 => ["name" => "牧师", "head" => "/storage/images/roles/oracle.png"],
            6 => ["name" => "斗魂", "head" => "/storage/images/roles/panda.png"],
        ],
        5 => [
            0 => ["name" => "斗士", "head" => "/storage/images/roles/worrior1.png"],
            1 => ["name" => "护卫", "head" => "/storage/images/roles/guardian1.png"],
            2 => ["name" => "潜行者", "head" => "/storage/images/roles/assassin1.png"],
            3 => ["name" => "猎人", "head" => "/storage/images/roles/archer1.png"],
            4 => ["name" => "巫师", "head" => "/storage/images/roles/pagan1.png"],
            5 => ["name" => "祭司", "head" => "/storage/images/roles/oracle1.png"],
            6 => ["name" => "拳刹", "head" => "/storage/images/roles/panda1.png"],
        ],
    ],
    'grow'                => [2 => "困难", 3 => "死亡"],
    'st'                  => [
        0 => [
            8  => ['label' => "项链", 'img' => "/storage/images/equip/8.png"],
            0  => ['label' => "头盔", 'img' => "/storage/images/equip/0.png"],
            9  => ['label' => "戒指", 'img' => "/storage/images/equip/9.png"],
            3  => ['label' => "护手", 'img' => "/storage/images/equip/3.png"],
            1  => ['label' => "胸甲", 'img' => "/storage/images/equip/1.png"],
            11 => ['label' => "手镯", 'img' => "/storage/images/equip/11.png"],
            5  => ['label' => "武器", 'img' => "/storage/images/equip/5.png"],
            2  => ['label' => "护腿", 'img' => "/storage/images/equip/2.png"],
            10 => ['label' => "戒指", 'img' => "/storage/images/equip/10.png"],
            6  => ['label' => "盾牌", 'img' => "/storage/images/equip/6.png"],
            4  => ['label' => "护鞋", 'img' => "/storage/images/equip/4.png"],
            12 => ['label' => "手镯", 'img' => "/storage/images/equip/12.png"],
        ],
        1 => [
            8  => ['label' => "项链", 'img' => "/storage/images/equip/8.png"],
            0  => ['label' => "头盔", 'img' => "/storage/images/equip/0.png"],
            9  => ['label' => "戒指", 'img' => "/storage/images/equip/9.png"],
            3  => ['label' => "护手", 'img' => "/storage/images/equip/3.png"],
            1  => ['label' => "胸甲", 'img' => "/storage/images/equip/1.png"],
            11 => ['label' => "手镯", 'img' => "/storage/images/equip/11.png"],
            5  => ['label' => "武器", 'img' => "/storage/images/equip/5.png"],
            2  => ['label' => "护腿", 'img' => "/storage/images/equip/2.png"],
            10 => ['label' => "戒指", 'img' => "/storage/images/equip/10.png"],
            6  => ['label' => "盾牌", 'img' => "/storage/images/equip/6.png"],
            4  => ['label' => "护鞋", 'img' => "/storage/images/equip/4.png"],
            12 => ['label' => "手镯", 'img' => "/storage/images/equip/12.png"],
        ],
        2 => [
            8  => ['label' => "项链", 'img' => "/storage/images/equip/8.png"],
            0  => ['label' => "头盔", 'img' => "/storage/images/equip/0.png"],
            9  => ['label' => "戒指", 'img' => "/storage/images/equip/9.png"],
            3  => ['label' => "护手", 'img' => "/storage/images/equip/3.png"],
            1  => ['label' => "胸甲", 'img' => "/storage/images/equip/1.png"],
            11 => ['label' => "手镯", 'img' => "/storage/images/equip/11.png"],
            5  => ['label' => "武器", 'img' => "/storage/images/equip/5.png"],
            2  => ['label' => "护腿", 'img' => "/storage/images/equip/2.png"],
            10 => ['label' => "戒指", 'img' => "/storage/images/equip/10.png"],
            6  => ['label' => "盾牌", 'img' => "/storage/images/equip/6.png"],
            4  => ['label' => "护鞋", 'img' => "/storage/images/equip/4.png"],
            12 => ['label' => "手镯", 'img' => "/storage/images/equip/12.png"],
        ],
    ],
    'og'                  => [0 => "允许交易", 1 => "账号阵营绑定", 2 => "角色绑定"],
    'dex'                 => [0 => "普通", 1 => "赞美", 2 => "畏惧", 3 => "传说", 4 => "祝福", 5 => "史诗", 6 => "上古", 7 => "特殊", 8 => "特殊"],
    'dex_color'           => [
        0 => "color: rgb(255, 255, 255);",
        1 => "color: rgb(128, 255, 255);",
        2 => "color: rgb(0, 128, 255);",
        3 => "color: rgb(0, 255, 64);",
        4 => "color: rgb(255, 255, 0);",
        5 => "color: rgb(255, 128, 0);",
        6 => "color: rgb(200, 200,255);",
        7 => "color: rgb(255, 0, 255);",
        8 => "color: rgb(128, 0, 255);",
    ],
    'text_color'          => [
        '0'  => 'color: rgb(255,0,255);',
        '1'  => 'color: rgb(128,255,255);',
        '2'  => 'color: rgb(0,255,0);',
        '3'  => 'color: rgb(255,255,0);',
        '4'  => 'color: rgb(255,0,0);',
        '5'  => 'color: rgb(161,158,156);',
        '50' => 'color: rgb(255,204,0);',
        '51' => 'color: rgb(204,255,51);'
    ],
    'itemtype'            => [42 => 1, 126 => 1, 120 => 2, 152 => 2, 150 => 3, 151 => 3],
    'item_type_lists'     => [1 => "坐骑", 2 => "宠物", 3 => "时装"],
    'wing_item_ids'       => [
        1 => ['label' => "天使之翼", 'itemid' => 121017], 2 => ['label' => "奈落之翼", 'itemid' => 121028],
        3 => ['label' => "暗夜溯影", 'itemid' => 121033], 4 => ['label' => "火龙之翼", 'itemid' => 121039],
        5 => ['label' => "花神之翼", 'itemid' => 121045],
    ],
    // 区服 - 背景
    'serverid_background' => [
        2 => "shaiya_01",
        1 => "shaiya_02",
        3 => "shaiya_03",
        6 => "shaiya_03",
    ],
    // 基础信息 - 字段名称映射
    'war'                 => [
        "hp"  => ["label" => "生命值", "options" => []],
        "sp"  => ["label" => "活力值", "options" => []],
        "mp"  => ["label" => "魔法值", "options" => []],
        "str" => ["label" => "力量", "options" => []],
        "dex" => ["label" => "敏捷", "options" => []],
        "int" => ["label" => "智力", "options" => []],
        "wis" => ["label" => "精神", "options" => []],
        "rec" => ["label" => "体质", "options" => []],
        "luc" => ["label" => "幸运", "options" => []],
        "ap"  => ["label" => "攻击模式", "options" => [0 => "无属性", 1 => "火属性", 2 => "水属性", 3 => "大地属性", 4 => "风属性"]],
        "dp"  => ["label" => "防御模式", "options" => [0 => "无属性", 1 => "火属性", 2 => "水属性", 3 => "大地属性", 4 => "风属性"]],
        "af"  => ["label" => "物理攻击", "options" => []],
        "as"  => ["label" => "射击攻击", "options" => []],
        "am"  => ["label" => "魔法攻击", "options" => []],
        "df"  => ["label" => "物理防御", "options" => []],
        "ds"  => ["label" => "射击防御", "options" => []],
        "dm"  => ["label" => "魔法防御", "options" => []],
    ],
    // 穿戴装备 - 字段名称映射
    'equip'               => [
        "hp"  => ["label" => "生命值", "options" => []],
        "sp"  => ["label" => "活力值", "options" => []],
        "mp"  => ["label" => "魔法值", "options" => []],
        "str" => ["label" => "力量", "options" => []],
        "dex" => ["label" => "敏捷", "options" => []],
        "int" => ["label" => "智力", "options" => []],
        "wis" => ["label" => "精神", "options" => []],
        "rec" => ["label" => "体质", "options" => []],
        "luc" => ["label" => "幸运", "options" => []],
        "ia"  => ["label" => "攻击下线", "options" => []],
        "iav" => ["label" => "攻击区间", "options" => []],
        "idd" => ["label" => "防御力", "options" => []],
        "idm" => ["label" => "抵抗力", "options" => []],
        "rd"  => ["label" => "伤害吸收", "options" => []],
        "sl"  => ["label" => "强化等级", "options" => []],
        "cj"  => ["label" => "可用职业", "options" => []],
        "g1"  => ["label" => "宝石1", "options" => []],
        "g2"  => ["label" => "宝石2", "options" => []],
        "g3"  => ["label" => "宝石3", "options" => []],
        "g4"  => ["label" => "宝石4", "options" => []],
        "g5"  => ["label" => "宝石5", "options" => []],
        "g6"  => ["label" => "宝石6", "options" => []],
    ],
    // 背包道具/角色仓库/外观 - 字段名称映射
    'backpack'            => [
        'itemname'    => ["label" => "名称", "options" => [],],
        'effect'      => ["label" => "攻击力", "options" => []],
        'effect3'     => ["label" => "防御力", "options" => []],
        'effect4'     => ["label" => "抵抗", "options" => []],
        'consthp'     => ["label" => "最大生命", "options" => []],
        'constsp'     => ["label" => "最大活力", "options" => []],
        'constmp'     => ["label" => "最大魔法值", "options" => []],
        'conststr'    => ["label" => "力量", "options" => []],
        'constdex'    => ["label" => "敏捷", "options" => []],
        'constrec'    => ["label" => "体质", "options" => []],
        'constint'    => ["label" => "智力", "options" => []],
        'constwis'    => ["label" => "精神", "options" => []],
        'constluc'    => ["label" => "幸运", "options" => []],
        'iconset'     => ["label" => "图片地址", "options" => []],
        'level'       => ["label" => "等级", "options" => []],
        'text'        => ["label" => "介绍", "options" => []],
        'og'          => ["label" => "道具状态：", "options" => []],
        'extduration' => ["label" => "是否永久", "options" => []],
    ],
    'god' => [
        'str' => ["label" => "力量", "options" => []],
        'dex' => ["label" => "敏捷", "options" => []],
        'rec' => ["label" => "体质", "options" => []],
        'int' => ["label" => "智力", "options" => []],
        'luc' => ["label" => "幸运", "options" => []],
        'wis' => ["label" => "精神", "options" => []],
        'hp'  => ["label" => "HP", "options" => []],
        'mp'  => ["label" => "MP", "options" => []],
        'sp'  => ["label" => "SP", "options" => []],
        'at'  => ["label" => "攻击力", "options" => []],
        'atv' => ["label" => "魔法力", "options" => []],
        'df'  => ["label" => "防御力", "options" => []],
        'dfm' => ["label" => "抵抗力", "options" => []],
    ],
    'wing'  => [
        'level' => ["label" => "等级", "options" => []],
        'grade' => ["label" => "等阶", "options" => [0 => "零阶", 1 => "一阶", 2 => "二阶", 3 => "三阶", 4 => "四阶", 5 => "五阶"]],
        'str' => ["label" => "力量", "options" => []],
        'dex' => ["label" => "敏捷", "options" => []],
        'rec' => ["label" => "体质", "options" => []],
        'int' => ["label" => "智力", "options" => []],
        'luc' => ["label" => "幸运", "options" => []],
        'wis' => ["label" => "精神", "options" => []],
    ],
];