<?php
// +----------------------------------------------------------------------
// | 应用设置
// +----------------------------------------------------------------------

return [
    // 应用地址
    'app_host'         => env('app.host', ''),
    // 应用的命名空间
    'app_namespace'    => '',
    // 是否启用路由
    'with_route'       => true,
    // 默认应用
    'default_app'      => 'index',
    // 默认时区
    'default_timezone' => 'Asia/Shanghai',

    // 应用映射（自动多应用模式有效）
    'app_map'          => [],
    // 域名绑定（自动多应用模式有效）
    'domain_bind'      => [],
    // 禁止URL访问的应用列表（自动多应用模式有效）
    'deny_app_list'    => ['model','event'],

    // 异常页面的模板文件
    'exception_tmpl'   => env('APP_DEBUG') ? '' : \think\facade\App::getAppPath() . '/error.tpl',

    // 错误显示信息,非调试模式有效
    'error_message'    => '系统错误',
    // 显示错误信息
    'show_error_msg'   => env('APP_DEBUG'),

    // 订单超时时间秒 30分钟
    'order_outtime' => 1800,
    // 我是卖家列表，可查看最近一个月
    'seller_lists_time' => 2592000,
    // 我的珍宝阁-我的订单-可查看最近一个月
    'my_order_lists_time' => 2592000,
    // 我的珍宝阁-我的收藏-可查看最近10天
    'my_collect_lists_time' => 864000,
    // 交易公示 - 3天
//    'trade_public_time' => 259200,
    'trade_public_time' => 300,
    // 交易出售 - 7天
//    'trade_seller_time' => 604800,
    'trade_seller_time' => 3600,
    // 角色数据延时15分钟，获取
    'role_delayed_time' => 0,
    //手续费
    'charge' => [
        'TradeGold' => [
            'charge_ratio'  => 0.05,
            'appoint_ratio' => 0.05,
            'min_charge'    => 0, // 按照比例计算
            'max_charge'    => 0, // 0无限制
            'min_price'     => 50,
        ],
        'TradeRole' => [
            'charge_ratio'  => 0.08,
            'appoint_ratio' => 0.12,
            'min_charge'    => 30, // 按照比例计算
            'max_charge'    => 8000,// 0无限制
            'min_price'     => 50,
        ],
        'TradeProp' => [
            'charge_ratio'  => 0.05,
            'appoint_ratio' => 0.05,
            'min_charge'    => 0, // 按照比例计算
            'max_charge'    => 5000,// 0无限制
            'min_price'     => 50,
        ]
    ],
    'sign_key'=>'b7b5a539e8b5566c1ccf02be8d02d3eb',
    // 平台介绍
    'plateform_intro' => "“珍宝阁”——官方认可的游戏线下交易平台，为满足玩家对线下交易的需求，同时保障大家可以远离骗子，并打击盗号者销赃行为，应运而生。
        在“珍宝阁”，玩家每一笔交易都是和游戏数据对应的，所有交易凭据都确切存在，而不再仅仅是一张截图或一段聊天记录，而且交易全程有系统监控，安全得到充分保障。因此在“珍宝阁”上的交易是合法且得到官方承认的。",
    'kf_url' => "http://bot.9vf.com/service/index.html", // 客服地址
];
