<?php
declare (strict_types = 1);

namespace app\service;
use Thrift\Client\ThriftClient;
use think\facade\Log;
class ThriftClientService extends \think\Service
{
    /**
     * 注册服务
     *
     * @return mixed
     */
    protected $client;

    public function register()
    {
        if (!$this->client) {
            $config = config('thrift.client');
            try {
                $this->client = new ThriftClient(
                    $config['host'],
                    $config['port']
                );
            } catch (\Exception $e) {
                Log::error('Thrift client init failed: ' . $e->getMessage());
                throw $e;
            }
        }
        return $this->client;
    }


    /**
     * 执行服务
     *
     * @return mixed
     */
    public function boot()
    {
        //
    }
}
